/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.LinearCode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.io.LinearCode.LinearCodeStacker;

public class LinearCodeLinkageParser {
    private LinkedHashMap<LinearCodeStacker, Node> lc2node = new LinkedHashMap();
    private HashMap<LinearCodeStacker, LinearCodeStacker> family = new HashMap();

    public LinearCodeLinkageParser(LinkedHashMap<LinearCodeStacker, Node> _lc2node, HashMap<LinearCodeStacker, LinearCodeStacker> _family) {
        this.lc2node = _lc2node;
        this.family = _family;
    }

    public GlyContainer start(ArrayList<LinearCodeStacker> _nodeList, GlyContainer _glyco) throws GlycanException {
        for (LinearCodeStacker lcStacker : _nodeList) {
            GlycanUndefinedUnit antennae = null;
            Node node = this.lc2node.get(lcStacker);
            _glyco = this.parseLinkage(lcStacker, _glyco);
            if (this.isRootOfFramgnets(lcStacker.getBaseUnit())) {
                antennae = new GlycanUndefinedUnit();
                antennae.addNode(node);
                antennae.setConnection(node.getParentEdge());
                for (Node parent : this.parseFragmentParents(lcStacker.getBaseUnit())) {
                    antennae.addParentNode(parent);
                }
            }
            if (!_glyco.containsNode(node)) {
                if (antennae != null && !antennae.containsNode(node)) {
                    _glyco.addNode(node);
                }
                if (antennae == null) {
                    _glyco.addNode(node);
                }
            }
            if (antennae == null) continue;
            _glyco.addGlycanUndefinedUnit(antennae);
        }
        return _glyco;
    }

    private GlyContainer parseLinkage(LinearCodeStacker _lcStacker, GlyContainer _glyco) throws GlycanException {
        if (_lcStacker.getBaseUnit().endsWith("}")) {
            _glyco = this.parseRepeating(_lcStacker, _glyco);
        }
        _glyco = this.parseSimpleLinkage(_lcStacker, _glyco);
        return _glyco;
    }

    private GlyContainer parseRepeating(LinearCodeStacker _lcStacker, GlyContainer _glyco) throws GlycanException {
        Node startNode = this.lc2node.get(_lcStacker);
        ArrayList<LinearCodeStacker> lcs = this.getEndRepeatingNode(_lcStacker);
        for (LinearCodeStacker endRep : lcs) {
            String startPos = String.valueOf(((Monosaccharide)startNode).getAnomericPosition());
            String endPos = "?";
            int count = -1;
            Node endNode = this.lc2node.get(endRep);
            String startRepPos = this.extractMultipleRepStart(_lcStacker).get(lcs.indexOf(endRep) + 1);
            Matcher matStartRep = Pattern.compile("(\\d|\\?)}+$").matcher(startRepPos);
            Matcher matEndRep = Pattern.compile("^\\{([n\\d+]).+").matcher(endRep.getBaseUnit());
            Edge repeatEdge = new Edge();
            Linkage lin = new Linkage();
            if (matStartRep.find()) {
                String string = endPos = matStartRep.group(1) != null ? matStartRep.group(1) : "?";
            }
            if (matEndRep.find()) {
                String sc = matEndRep.group(1) != null ? matEndRep.group(1) : "n";
                count = sc.equals("n") ? -1 : Integer.parseInt(sc);
            }
            lin.setChildLinkages(this.makeLinkage(startPos));
            lin.setParentLinkages(this.makeLinkage(endPos));
            repeatEdge.addGlycosidicLinkage(lin);
            GlycanRepeatModification repMod = new GlycanRepeatModification(null);
            repMod.setMaxRepeatCount(count);
            repMod.setMinRepeatCount(count);
            repeatEdge.setSubstituent(repMod);
            repMod.addParentEdge(repeatEdge);
            _glyco.addNode(endNode, repeatEdge, startNode);
        }
        return _glyco;
    }

    private GlyContainer parseSimpleLinkage(LinearCodeStacker _lcStacker, GlyContainer _glyco) throws GlycanException {
        Node parent = this.lc2node.get(this.family.get(_lcStacker));
        Monosaccharide current = (Monosaccharide)this.lc2node.get(_lcStacker);
        if (_lcStacker.getParentLinkage() != null) {
            Edge parentEdge = new Edge();
            Linkage lin = new Linkage();
            lin.setChildLinkages(this.makeLinkage(String.valueOf(current.getAnomericPosition())));
            lin.setParentLinkages(this.makeLinkage(_lcStacker.getParentLinkage()));
            parentEdge.addGlycosidicLinkage(lin);
            if (parent != null) {
                _glyco.addNode(parent, parentEdge, current);
            }
            if (parent == null && this.isRootOfFramgnets(_lcStacker.getBaseUnit())) {
                current.addParentEdge(parentEdge);
                parentEdge.setChild(current);
            }
        }
        return _glyco;
    }

    private ArrayList<LinearCodeStacker> getEndRepeatingNode(LinearCodeStacker _lcStacker) {
        int size = new ArrayList<LinearCodeStacker>(this.lc2node.keySet()).indexOf(_lcStacker) + 1;
        ArrayList<LinearCodeStacker> lcStackers = new ArrayList<LinearCodeStacker>();
        lcStackers.addAll(this.lc2node.keySet());
        List<LinearCodeStacker> subNodes = lcStackers.subList(0, size);
        Collections.reverse(subNodes);
        ArrayList<LinearCodeStacker> ret = this.countRepeats(subNodes);
        if (ret.isEmpty()) {
            ret = this.countRepeats(lcStackers.subList(lcStackers.indexOf(_lcStacker), lcStackers.size()));
        }
        return ret;
    }

    private ArrayList<LinearCodeStacker> countRepeats(Collection<LinearCodeStacker> _nodes) {
        int numOfstart = 0;
        ArrayList<LinearCodeStacker> retNodes = new ArrayList<LinearCodeStacker>();
        LinearCodeStacker start = new ArrayList<LinearCodeStacker>(_nodes).get(0);
        TreeMap<Integer, String> repPos = this.extractMultipleRepStart(start);
        block0: for (Integer unit : repPos.keySet()) {
            numOfstart = unit;
            for (LinearCodeStacker lcStacker : _nodes) {
                String notation = lcStacker.getBaseUnit();
                if (!this.isStartRep(notation) && !this.isEndRep(notation) && !this.isEndRepNonBondingSite(notation)) continue;
                if (this.isStartRep(notation) && !lcStacker.equals(start)) {
                    numOfstart += this.extractMultipleRepStart(lcStacker).size();
                }
                if (this.isEndRepNonBondingSite(notation)) {
                    if (--numOfstart == 0) {
                        retNodes.add(lcStacker);
                    }
                } else {
                    Matcher matEndRep = Pattern.compile("\\{[n|\\d+].+").matcher(notation);
                    while (matEndRep.find()) {
                        String repStatus = matEndRep.group(0);
                        if (this.isEndRep(notation)) {
                            if (numOfstart != 0) {
                                --numOfstart;
                            }
                            if (numOfstart == 0) {
                                retNodes.add(lcStacker);
                                break;
                            }
                        }
                        notation = notation.replaceFirst("\\{[n|\\d+]", "");
                        matEndRep = Pattern.compile("\\{[n|\\d+]").matcher(notation);
                    }
                }
                if (numOfstart == 0) continue block0;
            }
        }
        return retNodes;
    }

    private TreeMap<Integer, String> extractMultipleRepStart(LinearCodeStacker _node) {
        String repStart = _node.getBaseUnit();
        TreeMap<Integer, String> repPos = new TreeMap<Integer, String>();
        int key = 1;
        String startRep = repStart.substring(repStart.indexOf("}") - 1, repStart.length());
        String[] stringArray = startRep.split("}");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pos = stringArray[n2];
            repPos.put(key, String.valueOf(pos) + "}");
            ++key;
            ++n2;
        }
        return repPos;
    }

    private boolean isStartRep(String _notation) {
        return _notation.matches(".*}$");
    }

    private boolean isEndRep(String _notation) {
        return _notation.matches("^\\{[n|\\d]+.*");
    }

    private boolean isEndRepNonBondingSite(String _notation) {
        return _notation.matches(".+\\-.+\\-$");
    }

    private boolean isRootOfFramgnets(String _notation) {
        return _notation.lastIndexOf("%|") != -1;
    }

    private ArrayList<Node> parseFragmentParents(String _fragment) {
        ArrayList<Node> ret = new ArrayList<Node>();
        String anchor = _fragment.substring(_fragment.indexOf("=") + 1, _fragment.length() - 1);
        for (LinearCodeStacker lcStacker : this.lc2node.keySet()) {
            if (this.isRootOfFramgnets(lcStacker.getBaseUnit())) break;
            if (anchor.equals("%")) {
                ret.add(this.lc2node.get(lcStacker));
                continue;
            }
            if (lcStacker.getBaseUnit().indexOf(anchor) == -1 || this.isRootOfFramgnets(lcStacker.getBaseUnit())) continue;
            ret.add(this.lc2node.get(lcStacker));
        }
        return ret;
    }

    private LinkedList makeLinkage(String _position) {
        _position = _position.equals("?") ? "-1" : _position;
        LinkedList<Integer> ret = new LinkedList<Integer>();
        String[] stringArray = _position.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            ret.add(Integer.parseInt(unit));
            ++n2;
        }
        return ret;
    }
}

