/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.JSON;

import java.util.ArrayList;
import java.util.Iterator;
import org.glycoinfo.GlycanFormatconverter.Glycan.CrossLinkedTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.Glycan.SubstituentInterface;
import org.glycoinfo.GlycanFormatconverter.Glycan.SubstituentTemplate;
import org.glycoinfo.GlycanFormatconverter.io.JSON.GCJSONLinkageParser;
import org.glycoinfo.GlycanFormatconverter.util.SubstituentUtility;
import org.json.JSONArray;
import org.json.JSONObject;

public class GCJSONModificationParser {
    private GCJSONLinkageParser gclinParser = new GCJSONLinkageParser();

    public Substituent parseBridge(JSONObject _bridge) throws GlycanException {
        Linkage lin1 = null;
        Linkage lin2 = null;
        CrossLinkedTemplate subInter = null;
        SubstituentUtility subUtil = new SubstituentUtility();
        Iterator iterator = _bridge.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "PositionOne": {
                    lin1 = this.gclinParser.parsePosition(_bridge.getJSONObject(key));
                    break;
                }
                case "PositionTwo": {
                    lin2 = this.gclinParser.parsePosition(_bridge.getJSONObject(key));
                    break;
                }
                case "Notation": {
                    subInter = this.parseCrossLinkedTemplate(_bridge.getString(key));
                }
            }
        }
        if (subInter == null) {
            return null;
        }
        if (lin1 == null) {
            lin1 = new Linkage();
        }
        if (lin2 == null) {
            lin2 = new Linkage();
        }
        Substituent ret = new Substituent(subInter, lin1, lin2);
        return ret;
    }

    public Edge parseSubstituent(JSONObject _sub) throws GlycanException {
        Edge subEdge = new Edge();
        Enum subInter = null;
        SubstituentUtility subUtil = new SubstituentUtility();
        Linkage positionOne = null;
        Linkage positionTwo = null;
        Iterator iterator = _sub.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "PositionOne": {
                    positionOne = this.gclinParser.parsePosition(_sub.getJSONObject(key));
                    break;
                }
                case "PositionTwo": {
                    positionTwo = this.gclinParser.parsePosition(_sub.getJSONObject(key));
                    break;
                }
                case "Notation": {
                    subInter = positionTwo != null ? this.parseCrossLinkedTemplate(_sub.getString(key)) : this.parseSubstituentTemplate(_sub.getString(key));
                }
            }
        }
        Substituent sub = new Substituent((SubstituentInterface)((Object)subInter), positionOne, positionTwo);
        subEdge.setSubstituent(sub);
        subEdge.addGlycosidicLinkage(positionOne);
        if (positionTwo != null) {
            subEdge.addGlycosidicLinkage(positionTwo);
        }
        return subEdge;
    }

    public ArrayList<GlyCoModification> parseModifications(JSONArray _mod) throws GlycanException {
        ArrayList<GlyCoModification> ret = new ArrayList<GlyCoModification>();
        for (Object unit : _mod) {
            JSONObject mod = (JSONObject)unit;
            ModificationTemplate modTemp = null;
            int position = -1;
            Iterator iterator = mod.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                switch (key = (String)iterator.next()) {
                    case "PositionOne": {
                        position = mod.getInt(key);
                        break;
                    }
                    case "Notation": {
                        modTemp = this.parseModificationTemplate(mod.getString(key));
                    }
                }
            }
            if (modTemp == null) continue;
            GlyCoModification gMod = new GlyCoModification(modTemp, position);
            ret.add(gMod);
        }
        return ret;
    }

    public ArrayList<Edge> parseSubstituents(JSONArray _subs) throws GlycanException {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        for (Object key : _subs) {
            ret.add(this.parseSubstituent((JSONObject)key));
        }
        return ret;
    }

    public SubstituentTemplate parseSubstituentTemplate(String _notation) {
        SubstituentTemplate[] substituentTemplateArray = SubstituentTemplate.values();
        int n = substituentTemplateArray.length;
        int n2 = 0;
        while (n2 < n) {
            SubstituentTemplate value = substituentTemplateArray[n2];
            if (_notation.equals(value.toString())) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    public ModificationTemplate parseModificationTemplate(String _notation) {
        ModificationTemplate[] modificationTemplateArray = ModificationTemplate.values();
        int n = modificationTemplateArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModificationTemplate value = modificationTemplateArray[n2];
            if (_notation.equals(value.toString())) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    public CrossLinkedTemplate parseCrossLinkedTemplate(String _notation) {
        CrossLinkedTemplate[] crossLinkedTemplateArray = CrossLinkedTemplate.values();
        int n = crossLinkedTemplateArray.length;
        int n2 = 0;
        while (n2 < n) {
            CrossLinkedTemplate value = crossLinkedTemplateArray[n2];
            if (_notation.equals(value.toString())) {
                return value;
            }
            ++n2;
        }
        return null;
    }
}

