/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC;

import java.util.ArrayList;
import java.util.Iterator;
import org.glycoinfo.GlycanFormatconverter.Glycan.BaseTypeDictionary;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyCoModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.ModificationTemplate;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.SubstituentIUPACNotationConverter;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.ModifiedMonosaccharideDescriptor;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.PrefixDescriptor;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.ThreeLetterCodeConverter;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameDictionary;
import org.glycoinfo.GlycanFormatconverter.util.TrivialName.TrivialNameException;

public class IUPACNotationConverter {
    private StringBuilder threeLetterCode = new StringBuilder();
    private StringBuilder coreCode = new StringBuilder();
    private SubstituentIUPACNotationConverter subConv = new SubstituentIUPACNotationConverter();

    public SubstituentIUPACNotationConverter getSubConv() {
        return this.subConv;
    }

    public String getCoreCode() {
        return this.coreCode.toString();
    }

    public String getThreeLetterCode() {
        return this.threeLetterCode.toString();
    }

    public void makeTrivialName(Node _node) throws GlycanException {
        Monosaccharide mono = (Monosaccharide)_node;
        ThreeLetterCodeConverter threeCon = new ThreeLetterCodeConverter();
        threeCon.start(_node);
        StringBuilder trivialName = threeCon.getThreeLetterCode().equals("") ? (mono.getStereos().isEmpty() ? new StringBuilder(mono.getSuperClass().getSuperClass()) : new StringBuilder(this.makeStandardName(mono))) : new StringBuilder(this.makeTrivialName(mono, threeCon));
        this.subConv.start(trivialName.toString(), mono);
        this.threeLetterCode = new StringBuilder(trivialName);
        trivialName.append(this.subConv.getCoreSubstituentNotaiton());
        this.coreCode.append((CharSequence)trivialName);
        if (this.makeAcidicStatus(mono).equals("A")) {
            this.coreCode.append("A");
        }
    }

    private String makeStandardName(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        StringBuilder ret = new StringBuilder();
        Iterator iterStereo = mono.getStereos().iterator();
        while (iterStereo.hasNext()) {
            String stereo = (String)iterStereo.next();
            String configuration = this.makeConfiguration(stereo);
            String threeLetter = this.trimThreeLetterPrefix(stereo, configuration);
            if (mono.getStereos().size() != 1) {
                ret.append(configuration.equals("x") ? "?" : configuration.toUpperCase());
                ret.append("-");
            }
            if (this.isFuzzyMotif(_node)) {
                String prefix = threeLetter.substring(0, 1);
                threeLetter = threeLetter.replaceFirst(prefix, prefix.toLowerCase());
            }
            ret.append(threeLetter);
            if (!iterStereo.hasNext()) continue;
            ret.append("-");
        }
        if (this.isFuzzyMotif(_node)) {
            ret = this.appendSuperClass(_node, ret);
        }
        return ret.toString();
    }

    private String makeTrivialName(Node _node, ThreeLetterCodeConverter _threeCon) {
        Monosaccharide mono = (Monosaccharide)_node;
        String trivial = _threeCon.getThreeLetterCode();
        StringBuilder ret = new StringBuilder(trivial);
        if (mono.getSuperClass().getSize() > _threeCon.getSize()) {
            ret = this.appendSuperClass(_node, ret);
        }
        return ret.toString();
    }

    public String makeConfiguration(String _stereo) {
        String configuration = "?";
        _stereo = this.trimThreeLetterPrefix(_stereo);
        BaseTypeDictionary baseDict = BaseTypeDictionary.forName(_stereo.toLowerCase());
        configuration = baseDict.getConfiguration();
        return configuration;
    }

    private StringBuilder appendSuperClass(Node _node, StringBuilder _temp) {
        if (this.isFuzzyMotif(_node)) {
            char prefix = _temp.toString().charAt(0);
            if (_temp.indexOf("-") == -1) {
                _temp = _temp.replace(0, 1, String.valueOf(prefix).toLowerCase());
            }
            _temp.append(((Monosaccharide)_node).getSuperClass().getSuperClass());
        }
        return _temp;
    }

    private String trimThreeLetterPrefix(String _letter, String _configuration) {
        if (_configuration.equals("?")) {
            if (_letter.startsWith("d/l-")) {
                _letter = _letter.replaceFirst("d/l-", "");
            }
            if (_letter.startsWith("l/d-")) {
                _letter = _letter.replaceFirst("l/d-", "");
            }
        } else {
            _letter = _letter.replaceFirst(_configuration, "");
        }
        StringBuilder ret = new StringBuilder(_letter);
        ret = ret.replace(0, 1, ret.substring(0, 1).toUpperCase());
        return ret.toString();
    }

    private String trimThreeLetterPrefix(String _letter) {
        if (_letter.startsWith("d/l-")) {
            _letter = _letter.replaceFirst("d/l-", "");
        }
        if (_letter.startsWith("l/d-")) {
            _letter = _letter.replaceFirst("l/d-", "");
        }
        if (_letter.length() == 3) {
            StringBuilder ret = new StringBuilder(_letter);
            ret = ret.replace(0, 1, ret.substring(0, 1).toUpperCase());
            return ret.toString();
        }
        return _letter;
    }

    public String extractUlonic(Monosaccharide _mono) {
        String ret = "";
        for (GlyCoModification mod : _mono.getModifications()) {
            ModificationTemplate modT = mod.getModificationTemplate();
            if (modT.equals((Object)ModificationTemplate.KETONE_U)) {
                ret = String.valueOf(ret) + mod.getPositionOne() + modT.getIUPACnotation();
            }
            if (modT.equals((Object)ModificationTemplate.ULOSONIC)) {
                ret = String.valueOf(ret) + mod.getPositionOne() + modT.getIUPACnotation();
            }
            if (!modT.equals((Object)ModificationTemplate.KETONE)) continue;
            ret = String.valueOf(ret) + mod.getPositionOne() + modT.getIUPACnotation();
        }
        return ret;
    }

    public String extractDLconfiguration(String _stereo) {
        if (_stereo.length() == 4) {
            return _stereo.substring(0, 1);
        }
        if (_stereo.startsWith("d/l-") || _stereo.startsWith("l/d-")) {
            return "?";
        }
        return "?";
    }

    private boolean isFuzzyMotif(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        SuperClass superclass = mono.getSuperClass();
        if (superclass == null) {
            return false;
        }
        if (mono.getStereos().size() > 1) {
            return true;
        }
        if (mono.getStereos().contains(superclass.getSuperClass().toLowerCase())) {
            return false;
        }
        for (GlyCoModification mod : mono.getModifications()) {
            ModificationTemplate modT = mod.getModificationTemplate();
            if (modT == null) continue;
            if (superclass.getSize() == mod.getPositionOne().intValue()) {
                return false;
            }
            if (modT.equals((Object)ModificationTemplate.DEOXY)) {
                return true;
            }
            if (modT.equals((Object)ModificationTemplate.METHYL)) {
                return true;
            }
            if (modT.equals((Object)ModificationTemplate.ALDEHYDE) && mod.getPositionOne() != 1) {
                return true;
            }
            if (modT.equals((Object)ModificationTemplate.ULOSONIC) && mod.getPositionOne() != 2) {
                return true;
            }
            if (modT.equals((Object)ModificationTemplate.KETONE_U)) {
                return true;
            }
            if (modT.equals((Object)ModificationTemplate.UNSATURATION_EL)) {
                return true;
            }
            if (modT.equals((Object)ModificationTemplate.UNSATURATION_EU)) {
                return true;
            }
            if (modT.equals((Object)ModificationTemplate.UNSATURATION_FL)) {
                return true;
            }
            if (modT.equals((Object)ModificationTemplate.UNSATURATION_FU)) {
                return true;
            }
            if (modT.equals((Object)ModificationTemplate.UNSATURATION_ZL)) {
                return true;
            }
            if (!modT.equals((Object)ModificationTemplate.UNSATURATION_ZU)) continue;
            return true;
        }
        return false;
    }

    public String makeDeoxyPosition(Monosaccharide _mono) throws TrivialNameException {
        if (_mono.getModifications().isEmpty()) {
            return "";
        }
        ArrayList<GlyCoModification> deoxys = new ArrayList<GlyCoModification>();
        for (GlyCoModification mod : _mono.getModifications()) {
            ModificationTemplate modT = mod.getModificationTemplate();
            if (modT.equals((Object)ModificationTemplate.DEOXY)) {
                deoxys.add(mod);
            }
            if (modT.equals((Object)ModificationTemplate.METHYL)) {
                deoxys.add(mod);
            }
            if (modT.equals((Object)ModificationTemplate.UNSATURATION_EL)) {
                deoxys.add(mod);
            }
            if (modT.equals((Object)ModificationTemplate.UNSATURATION_FL)) {
                deoxys.add(mod);
            }
            if (!modT.equals((Object)ModificationTemplate.UNSATURATION_ZL)) continue;
            deoxys.add(mod);
        }
        StringBuilder deoxy = new StringBuilder();
        PrefixDescriptor a_enumPrefix = PrefixDescriptor.forNumber(deoxys.size());
        Iterator i = deoxys.iterator();
        while (i.hasNext()) {
            deoxy.append(((GlyCoModification)i.next()).getPositionOne());
            if (i.hasNext()) {
                deoxy.append(",");
                continue;
            }
            deoxy.append("-" + a_enumPrefix.getPrefix() + "deoxy-");
        }
        return deoxy.toString();
    }

    public boolean isAlditol(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        if (mono.getAnomericPosition() != 0) {
            return false;
        }
        boolean ret = false;
        for (GlyCoModification mod : mono.getModifications()) {
            if (mod.getPositionOne() == 1 && mod.getModificationTemplate().equals((Object)ModificationTemplate.HYDROXYL)) {
                ret = true;
            }
            if (mod.getPositionOne() != 2 || !mod.getModificationTemplate().equals((Object)ModificationTemplate.KETONE_U)) continue;
            ret = false;
        }
        return ret;
    }

    public boolean isAldehyde(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        boolean aldehyde = false;
        if (mono.getAnomericPosition() != 0) {
            return false;
        }
        for (GlyCoModification mod : mono.getModifications()) {
            ModificationTemplate modT = mod.getModificationTemplate();
            if (!modT.equals((Object)ModificationTemplate.ALDEHYDE) || mod.getPositionOne() != 1) continue;
            aldehyde = true;
        }
        return aldehyde;
    }

    public String makeAcidicStatus(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        boolean headAcid = false;
        boolean tailAcid = false;
        ModificationTemplate acid = ModificationTemplate.ALDONICACID;
        SuperClass superclass = mono.getSuperClass();
        for (GlyCoModification mod : mono.getModifications()) {
            ModificationTemplate modT = mod.getModificationTemplate();
            if (mod.getPositionOne() == 1 && modT.equals((Object)ModificationTemplate.ALDONICACID)) {
                headAcid = true;
            }
            if (mod.getPositionOne().intValue() != superclass.getSize() || !modT.equals((Object)ModificationTemplate.URONICACID)) continue;
            tailAcid = true;
        }
        if (headAcid && tailAcid) {
            return "-aric";
        }
        if (headAcid && !tailAcid) {
            return "-onic";
        }
        if (!headAcid && tailAcid) {
            if (superclass.equals((Object)SuperClass.HEX)) {
                return "A";
            }
            return "-uronic";
        }
        return "";
    }

    public boolean containUlonicAcid(String _code) {
        TrivialNameDictionary dict = TrivialNameDictionary.forThreeLetterCode(_code);
        ModifiedMonosaccharideDescriptor mdict = ModifiedMonosaccharideDescriptor.forTrivialName(_code);
        if (dict != null) {
            if (dict.equals((Object)TrivialNameDictionary.KO)) {
                return true;
            }
            if (dict.equals((Object)TrivialNameDictionary.NEU)) {
                return true;
            }
            if (dict.equals((Object)TrivialNameDictionary.LEG)) {
                return true;
            }
            if (dict.equals((Object)TrivialNameDictionary.KDO)) {
                return true;
            }
            if (dict.equals((Object)TrivialNameDictionary.KDN)) {
                return true;
            }
        }
        if (mdict != null) {
            if (mdict.equals((Object)ModifiedMonosaccharideDescriptor.NEU5AC)) {
                return true;
            }
            if (mdict.equals((Object)ModifiedMonosaccharideDescriptor.NEU5GC)) {
                return true;
            }
        }
        return false;
    }

    public String defineRingSize(Node _node) {
        Monosaccharide mono = (Monosaccharide)_node;
        int start = mono.getRingStart();
        int end = mono.getRingEnd();
        if (start == 0 && end == 0) {
            return "";
        }
        if (start == -1 && end == -1) {
            return "";
        }
        if (start != -1 && end == -1) {
            return "?";
        }
        if (start + end == 5 || start == 2 && end == 5) {
            return "f";
        }
        if (start + end == 6 || start == 2 && end == 6) {
            return "p";
        }
        return "?";
    }
}

