/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.IUPAC;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.ExporterInterface;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.CondensedConverter;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACExporterUtility;
import org.glycoinfo.GlycanFormatconverter.util.similarity.NodeSimilarity;

public class IUPACCondensedExporter
extends IUPACExporterUtility
implements ExporterInterface {
    private StringBuilder condensed = new StringBuilder();
    private HashMap<Node, String> notationIndex = new HashMap();
    private NodeSimilarity gu = new NodeSimilarity();
    private boolean isGlycanWeb;

    public IUPACCondensedExporter(boolean _isGlycanWeb) {
        this.isGlycanWeb = _isGlycanWeb;
    }

    public String getIUPACCondensed() {
        return this.condensed.toString();
    }

    public void start(GlyContainer _glyCo) throws GlycanException {
        for (Node _node : _glyCo.getAllNodes()) {
            this.makeMonosaccharideNotation(_node);
            this.makeLinkageNotation(_node);
        }
        for (GlycanUndefinedUnit und : _glyCo.getUndefinedUnit()) {
            if (!(und.getNodes().get(0) instanceof Substituent)) continue;
            this.makeSubstituentNotation(und);
        }
        this.makeFragmentsAnchor(_glyCo);
        if (_glyCo.isComposition()) {
            this.condensed.insert(0, this.makeComposition(_glyCo));
            return;
        }
        ArrayList<Node> sortedList = this.gu.sortAllNode(_glyCo.getRootNodes().get(0));
        this.condensed.insert(0, this.makeSequence(sortedList));
        this.condensed.insert(0, this.makeFragmentsSequence(_glyCo.getUndefinedUnit()));
    }

    @Override
    public String makeComposition(GlyContainer _glyCo) {
        StringBuilder ret = new StringBuilder();
        ArrayList<String> nodeList = new ArrayList<String>();
        Iterator<GlycanUndefinedUnit> iterUnd = _glyCo.getUndefinedUnit().iterator();
        while (iterUnd.hasNext()) {
            nodeList.add(this.notationIndex.get(iterUnd.next().getNodes().get(0)));
        }
        LinkedHashMap<String, Integer> block = new LinkedHashMap<String, Integer>();
        for (String notation : nodeList) {
            if (block.containsKey(notation)) {
                block.put(notation, (Integer)block.get(notation) + 1);
                continue;
            }
            block.put(notation, 1);
        }
        Iterator iterKey = block.keySet().iterator();
        while (iterKey.hasNext()) {
            String notation = (String)iterKey.next();
            ret.append("{" + notation + "}" + block.get(notation));
            if (!iterKey.hasNext()) continue;
            ret.append(",");
        }
        return ret.toString();
    }

    @Override
    public String makeFragmentsSequence(ArrayList<GlycanUndefinedUnit> _fragments) throws GlycanException {
        StringBuilder ret = new StringBuilder();
        for (GlycanUndefinedUnit und : _fragments) {
            for (Node antennae : und.getRootNodes()) {
                ArrayList<Node> sortedFragments = this.gu.sortAllNode(antennae);
                this.condensed.insert(0, String.valueOf(this.makeSequence(sortedFragments)) + ",");
            }
        }
        return ret.toString();
    }

    @Override
    public void makeFragmentsAnchor(GlyContainer _glyCo) throws GlycanException {
        if (_glyCo.isComposition()) {
            return;
        }
        for (GlycanUndefinedUnit und : _glyCo.getUndefinedUnit()) {
            String notation;
            int index = _glyCo.getUndefinedUnit().indexOf(und) + 1;
            for (Node antennae : und.getRootNodes()) {
                notation = this.notationIndex.get(antennae);
                notation = String.valueOf(notation) + "=" + index + "$";
                this.notationIndex.put(antennae, notation);
            }
            for (Node parent : und.getParents()) {
                notation = this.notationIndex.get(parent);
                this.notationIndex.put(parent, String.valueOf(index) + "$" + (index > 1 ? "|" : "") + notation);
            }
        }
    }

    @Override
    public String makeSequence(ArrayList<Node> _nodes) {
        int branch = 0;
        StringBuilder encode = new StringBuilder();
        for (Node skey : _nodes) {
            StringBuilder notation = new StringBuilder(this.notationIndex.get(skey));
            if (this.gu.isMainChaineBranch(skey)) {
                notation.append("]");
                ++branch;
            }
            if (this.gu.countChildren(skey) == 0 && branch > 0) {
                notation.insert(0, "[");
                --branch;
            }
            encode.insert(0, notation);
        }
        return encode.toString();
    }

    @Override
    public void makeSubstituentNotation(GlycanUndefinedUnit _und) {
        Node sub = _und.getNodes().get(0);
        if (!(sub instanceof Substituent)) {
            return;
        }
        if (!this.notationIndex.containsKey(sub)) {
            String subNotation = ((Substituent)sub).getSubstituent().getIUPACnotation();
            subNotation = String.valueOf(this.extractPosition(_und.getConnection().getGlycosidicLinkages().get(0).getParentLinkages())) + subNotation;
            this.notationIndex.put(sub, subNotation);
        }
    }

    @Override
    public void makeMonosaccharideNotation(Node _node) throws GlycanException {
        CondensedConverter condConv = new CondensedConverter();
        if (!this.notationIndex.containsKey(_node)) {
            this.notationIndex.put(_node, condConv.start(_node, this.isGlycanWeb));
        }
    }

    @Override
    public void makeLinkageNotation(Node _node) {
        StringBuilder notation = new StringBuilder(this.notationIndex.get(_node));
        Monosaccharide mono = (Monosaccharide)_node;
        if (!mono.getParentEdges().isEmpty()) {
            StringBuilder linkagePos = new StringBuilder("(");
            Iterator<Edge> iterParent = this.gu.sortParentSideEdges(mono.getParentEdges()).iterator();
            while (iterParent.hasNext()) {
                Edge parentEdge = iterParent.next();
                Substituent sub = (Substituent)parentEdge.getSubstituent();
                if (parentEdge.isCyclic() && linkagePos.charAt(linkagePos.length() - 1) == ':') {
                    linkagePos.append("(");
                }
                linkagePos.append(this.makeChildSidePosition(parentEdge));
                if (sub != null && sub instanceof GlycanRepeatModification && !parentEdge.isCyclic()) {
                    linkagePos.append("]");
                    linkagePos.append(this.makeRepeatingCount((GlycanRepeatModification)parentEdge.getSubstituent()));
                }
                linkagePos.append(this.makeProbabilityAnnotation(parentEdge));
                if (!parentEdge.isRepeat() && !parentEdge.isCyclic()) {
                    linkagePos.append(this.makeParentSidePosition(parentEdge));
                    if (!iterParent.hasNext()) {
                        linkagePos.append(")");
                    }
                }
                if (!iterParent.hasNext()) continue;
                linkagePos.append(":");
            }
            notation.append((CharSequence)linkagePos);
        }
        if (mono.getParentEdges().isEmpty() && !mono.getAnomer().equals((Object)AnomericStateDescriptor.OPEN) && !this.isFacingAnoms(mono.getChildEdges())) {
            notation.append("(");
            char parentAnom = mono.getAnomer().getAnomericState();
            notation.append((char)(parentAnom == 'x' ? 63 : (parentAnom == 'o' ? 63 : (int)parentAnom)));
            if (mono.getAnomericPosition() == 0 || mono.getAnomericPosition() == -1) {
                notation.append("?");
            } else {
                notation.append(mono.getAnomericPosition());
            }
            notation.append("-");
        }
        for (Edge edge : this.gu.sortParentSideEdges(mono.getChildEdges())) {
            Substituent sub = (Substituent)edge.getSubstituent();
            if (sub == null || !(sub instanceof GlycanRepeatModification)) continue;
            StringBuilder endReppos = new StringBuilder();
            if (!edge.isCyclic()) {
                endReppos.append("[");
            }
            if (sub.getSubstituent() != null) {
                endReppos.append("-");
                endReppos.append(sub.getFirstPosition() == null ? "" : this.extractPosition(sub.getFirstPosition().getChildLinkages()));
                endReppos.append(sub.getNameWithIUPAC());
                endReppos.append(sub.getSecondPosition() == null ? "" : this.extractPosition(sub.getSecondPosition().getChildLinkages()));
                endReppos.append("-");
            }
            endReppos.append(this.makeParentSidePosition(edge));
            endReppos.append(")");
            notation.insert(0, endReppos);
        }
        this.notationIndex.put(mono, notation.toString());
    }

    private String makeParentSidePosition(Edge _parentEdge) {
        if (_parentEdge.getGlycosidicLinkages().size() > 1) {
            return "";
        }
        StringBuilder ret = new StringBuilder(this.extractPosition(_parentEdge.getGlycosidicLinkages().get(0).getParentLinkages()));
        if (this.isFacingAnom(_parentEdge)) {
            Monosaccharide parent = (Monosaccharide)_parentEdge.getParent();
            char parentAnom = parent.getAnomer().getAnomericState();
            ret.append(parentAnom == 'x' ? (char)'?' : (char)parentAnom);
        }
        return ret.toString();
    }

    private String makeChildSidePosition(Edge _parentEdge) {
        StringBuilder ret = new StringBuilder();
        Node child = _parentEdge.getChild();
        if (child != null) {
            int anomerPos = ((Monosaccharide)child).getAnomericPosition();
            int childPos = _parentEdge.getGlycosidicLinkages().get(0).getChildLinkages().get(0);
            if (!((Monosaccharide)child).getAnomer().equals((Object)AnomericStateDescriptor.OPEN) && anomerPos == childPos) {
                char parentAnom = ((Monosaccharide)_parentEdge.getChild()).getAnomer().getAnomericState();
                ret.append(parentAnom == 'x' ? (char)'?' : (char)parentAnom);
            }
        }
        ret.append(this.extractPosition(_parentEdge.getGlycosidicLinkages().get(0).getChildLinkages()));
        if (_parentEdge.getSubstituent() != null && !(_parentEdge.getSubstituent() instanceof GlycanRepeatModification)) {
            Substituent sub = (Substituent)_parentEdge.getSubstituent();
            ret.append("-");
            ret.append(sub.getFirstPosition() == null ? "" : this.extractPosition(sub.getFirstPosition().getChildLinkages()));
            ret.append(sub.getNameWithIUPAC());
            ret.append(sub.getSecondPosition() == null ? "" : this.extractPosition(sub.getSecondPosition().getChildLinkages()));
        }
        ret.append("-");
        return ret.toString();
    }
}

