/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.report.tablehelpers;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderCommand;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.datamodel.ms.annotation.glycan.report.tablemodel.MSGlycanAnnotationReportTableDataObject;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.display.control.table.tablecore.IGritsTable;
import org.grits.toolbox.entry.ms.annotation.glycan.report.command.MSGlycanAnnotationReportViewColumnChooserCommandHandler;
import org.grits.toolbox.entry.ms.annotation.glycan.report.command.ViewMSOverviewFromMergeCommandExecutor;
import org.grits.toolbox.entry.ms.annotation.glycan.report.process.loader.MSGlycanAnnotationReportTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.glycan.report.views.MSGlycanAnnotationReportMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.glycan.tablehelpers.MSGlycanAnnotationTable;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTable;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTableDataChangedMessage;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationEntityScroller;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationTableBase;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecPeaksView;
import org.grits.toolbox.merge.om.data.ExperimentAnnotation;
import org.grits.toolbox.merge.om.data.MergeSettings;

public class MSGlycanAnnotationReportTable
extends MSGlycanAnnotationTable {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationReportTable.class);

    public MSGlycanAnnotationReportTable(MSAnnotationTableBase parent, TableDataProcessor xmlExtractor) throws Exception {
        super(parent, xmlExtractor);
    }

    public MSGlycanAnnotationReportTable(Composite parent, MSGlycanAnnotationReportTable parentTable, int iRowNumber, int iScanNum, String sRowId) {
        super(parent, (MSGlycanAnnotationTable)parentTable, iRowNumber, iScanNum, sRowId);
    }

    public void createMainTable() throws Exception {
        try {
            this.initCommonTableComponents();
            this.initColumnChooserLayer();
            this.updateEventListForVisibility();
            this.updateImageRegistry(false);
            this.updateRowVisibilityAfterRead();
            this.finishNatTable();
            this.performAutoResizeAfterPaint();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create table.", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public int getScanNumberForVisibility(MSAnnotationTableDataObject tdo, int i) {
        return 0;
    }

    public int getScanNumberForVisibility(MSAnnotationTable table, int i) {
        return 0;
    }

    protected void initColumnChooserLayer() {
        MSGlycanAnnotationReportViewColumnChooserCommandHandler columnChooserCommandHandler = new MSGlycanAnnotationReportViewColumnChooserCommandHandler((IGritsTable)this);
        this.columnGroupHeaderLayer.registerCommandHandler((ILayerCommandHandler)columnChooserCommandHandler);
    }

    private MSGlycanAnnotationReportTableDataObject getMyTableDataObject() {
        return (MSGlycanAnnotationReportTableDataObject)this.getGRITSTableDataObject();
    }

    public void refreshTableImages() {
        this.updateImageRegistry(true);
        this.performAutoResize();
    }

    protected void initImageConfigRegistry() {
        if (this.getMyTableDataObject().getCartoonCols() != null && this.getGRITSTableDataObject().getTableData() != null && !this.getGRITSTableDataObject().getTableData().isEmpty()) {
            int i = 0;
            while (i < this.getGRITSTableDataObject().getTableData().size()) {
                int j = 0;
                while (j < this.getMyTableDataObject().getCartoonCols().size()) {
                    Integer iCartoonCol = (Integer)this.getMyTableDataObject().getCartoonCols().get(j);
                    String sCartoonFile = (String)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get(iCartoonCol);
                    if (sCartoonFile != null && !sCartoonFile.equals("")) {
                        int iInx = sCartoonFile.indexOf(".png");
                        String sSequence = sCartoonFile.substring(0, iInx);
                        this.registerImage(this.configRegistry, sSequence, sCartoonFile);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected void updateImageRegistry(boolean bForceImageRedraw) {
        if (this.getGRITSTableDataObject().getTableData() == null || this.getGRITSTableDataObject().getTableData().isEmpty() || this.getMyTableDataObject().getPeakIdCols().isEmpty() || this.getMyTableDataObject().getCartoonCols().isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.getGRITSTableDataObject().getTableData().size()) {
            if (((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)this.getMyTableDataObject().getCartoonCols().get(0)) != null) {
                Integer iScanNum = null;
                if (this.getMyTableDataObject().getScanNoCols() != null && !this.getMyTableDataObject().getScanNoCols().isEmpty() && ((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)this.getMyTableDataObject().getScanNoCols().get(0)) != null) {
                    iScanNum = (Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)this.getMyTableDataObject().getScanNoCols().get(0));
                }
                int j = 0;
                while (j < this.getMyTableDataObject().getCartoonCols().size()) {
                    int iCartoonCol = (Integer)this.getMyTableDataObject().getCartoonCols().get(j);
                    Integer iPeakId = null;
                    String sCartoonID = (String)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get(iCartoonCol);
                    if (sCartoonID != null && !sCartoonID.equals("")) {
                        String sSequence;
                        int iInx = sCartoonID.indexOf(".png");
                        if (iInx < 0) {
                            logger.error((Object)"Invalid format for cartoon string. PNG not found!");
                        }
                        if ((sSequence = sCartoonID.substring(0, iInx)) != null && !sSequence.equals("")) {
                            if (this.getMyTableDataObject().getCartoonCols().size() == this.getMyTableDataObject().getPeakIdCols().size()) {
                                iPeakId = (Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)this.getMyTableDataObject().getPeakIdCols().get(j));
                            } else if (j == 0) {
                                int k = 1;
                                while (k < this.getMyTableDataObject().getCartoonCols().size()) {
                                    String sThisCartoonID = (String)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)this.getMyTableDataObject().getCartoonCols().get(k));
                                    if (sThisCartoonID != null && sCartoonID.equals(sThisCartoonID)) {
                                        iPeakId = (Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)this.getMyTableDataObject().getPeakIdCols().get(k - 1));
                                    }
                                    ++k;
                                }
                            } else {
                                iPeakId = (Integer)((GRITSListDataRow)this.getGRITSTableDataObject().getTableData().get(i)).getDataRow().get((Integer)this.getMyTableDataObject().getPeakIdCols().get(j - 1));
                                if (iPeakId == null) {
                                    logger.debug((Object)"Null peak id!");
                                }
                            }
                            boolean bInvisible = false;
                            if (iPeakId != null) {
                                bInvisible = this.getGRITSTableDataObject().isInvisibleRow(iScanNum, iPeakId.toString());
                            }
                            Object ob = this.configRegistry.getSpecificConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", sCartoonID);
                            if (bForceImageRedraw) {
                                this.configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", sCartoonID);
                                this.registerImage(this.configRegistry, sSequence, sCartoonID);
                            } else if (ob == null && !bInvisible) {
                                this.registerImage(this.configRegistry, sSequence, sCartoonID);
                            } else if (ob != null && bInvisible) {
                                this.configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", sCartoonID);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public TableViewerColumnSettings getPreferenceSettingsFromCurrentView() {
        if (this.columnGroupModel == null || this.columnGroupModel.isEmpty()) {
            return super.getPreferenceSettingsFromCurrentView();
        }
        if (this.getMyTableDataObject().getFirstGroupIndices() == null) {
            this.getMyTableDataObject().discoverGroups(this.columnGroupModel);
        }
        TableViewerColumnSettings newEntity = new TableViewerColumnSettings();
        if (this.getMyTableDataObject().getFirstGroupIndices().size() < 2) {
            logger.log((Priority)Level.WARN, (Object)"Not enough column groups to update visibility");
            return newEntity;
        }
        int iPos = 0;
        int i = 0;
        while (i < 2) {
            ColumnGroupModel.ColumnGroup group = this.columnGroupModel.getColumnGroupByIndex(((Integer)this.getMyTableDataObject().getFirstGroupIndices().get(i)).intValue());
            List members = group.getMembers();
            int j = 0;
            while (j < members.size()) {
                int iColLayerInx = (Integer)members.get(j);
                int iColLayerPos = this.columnHeaderDataLayer.getColumnPositionByIndex(iColLayerInx);
                GRITSColumnHeader header = (GRITSColumnHeader)this.columnHeaderDataLayer.getDataValueByPosition(iColLayerPos, 0);
                newEntity.setVisColInx(header, Integer.valueOf(iPos++));
                ++j;
            }
            ++i;
        }
        return newEntity;
    }

    public void updateTable(MSAnnotationTableDataChangedMessage message) {
        int iNumRows = message.getParentTable().getBottomDataLayer().getRowCount();
        if (iNumRows == 0) {
            return;
        }
        int i = 0;
        while (i < iNumRows) {
            if (message.getParentTable().getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)message.getParentTable().getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), i) != null && message.getParentTable().getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)message.getParentTable().getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), i) != null) {
                Integer iPeakId = (Integer)message.getParentTable().getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)message.getParentTable().getGRITSTableDataObject()).getPeakIdCols().get(0)).intValue(), i);
                String sId = message.getParentTable().getBottomDataLayer().getDataValueByPosition(((Integer)((MSAnnotationTableDataObject)message.getParentTable().getGRITSTableDataObject()).getFeatureIdCols().get(0)).intValue(), i).toString();
                MSAnnotationEntityScroller.getCombinedKeyForLookup((Integer)iPeakId, (String)sId);
                if (message.getFeature().getId().equals(sId)) {
                    boolean bDirty;
                    int iRowInx;
                    boolean bCurSelected = (Boolean)message.getParentTable().getBottomDataLayer().getDataValueByPosition(0, i);
                    MSGlycanAnnotationReportTableDataProcessor proc = (MSGlycanAnnotationReportTableDataProcessor)this.getTableDataProcessor();
                    String sExpId = null;
                    if (message.getParentTable().getTableDataProcessor().getEntry().getProperty() instanceof MSAnnotationEntityProperty) {
                        MSAnnotationEntityProperty prop = (MSAnnotationEntityProperty)message.getParentTable().getTableDataProcessor().getEntry().getProperty();
                        sExpId = ((MSAnnotationProperty)prop.getParentProperty()).getMSAnnotationMetaData().getAnnotationId();
                    }
                    if ((iRowInx = proc.findMatchingRow(sExpId, iPeakId)) < 0 || !(bDirty = proc.toggleFeatureSelection(sExpId, iRowInx, message, bCurSelected))) break;
                    this.finishUpdateHiddenRowsAfterEdit(true);
                    this.parentView.setDirty(true);
                    break;
                }
            }
            ++i;
        }
    }

    public boolean startUpdateHiddenRowsAfterEdit(MSAnnotationTable subsetTable) {
        return super.startUpdateHiddenRowsAfterEdit(subsetTable);
    }

    public boolean updateViewFromPreferenceSettings() {
        boolean bTotalSuccess;
        block18: {
            block17: {
                bTotalSuccess = true;
                if (this.columnGroupModel == null || this.columnGroupModel.isEmpty()) {
                    return super.updateViewFromPreferenceSettings();
                }
                if (this.columnHeaderDataLayer != null && this.columnHeaderDataLayer.getColumnCount() != 0) break block17;
                return false;
            }
            int iNumCols = this.columnHeaderDataLayer.getColumnCount();
            if (iNumCols != 0) break block18;
            return false;
        }
        try {
            this.columnHideShowLayer.showAllColumns();
            ArrayList<Integer> alHiddenCols = new ArrayList<Integer>();
            if (this.getMyTableDataObject().getFirstGroupIndices() == null) {
                this.getMyTableDataObject().discoverGroups(this.columnGroupModel);
            }
            int i = 0;
            while (i < this.getMyTableDataObject().getFirstGroupIndices().size()) {
                ColumnGroupModel.ColumnGroup group = this.columnGroupModel.getColumnGroupByIndex(((Integer)this.getMyTableDataObject().getFirstGroupIndices().get(i)).intValue());
                List members = group.getMembers();
                int j = 0;
                while (j < members.size()) {
                    int iColLayerInx = (Integer)members.get(j);
                    int iColLayerPos = this.columnHeaderDataLayer.getColumnPositionByIndex(iColLayerInx);
                    String sHeaderKey = this.columnHeaderDataProvider.getDataKey(iColLayerPos, 0);
                    int iColShowLayerPos = LayerUtil.convertColumnPosition((ILayer)this.columnHeaderDataLayer, (int)iColLayerPos, (IUniqueIndexLayer)this.columnHideShowLayer);
                    if (this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().hasColumn(sHeaderKey)) {
                        int iPrefColPos = this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().getVisColInx(sHeaderKey);
                        if (iPrefColPos == -1) {
                            alHiddenCols.add(iColShowLayerPos);
                        }
                    } else {
                        alHiddenCols.add(iColShowLayerPos);
                        logger.warn((Object)("Header: " + sHeaderKey + " not found in preferences!"));
                    }
                    ++j;
                }
                ++i;
            }
            this.columnHideShowLayer.hideColumnPositions(alHiddenCols);
            Object selCell = this.getGRITSTableDataObject().getLastHeader().get(0);
            boolean bAddSelect = selCell.equals(TableDataProcessor.selColHeader);
            int iNumVisFirstGroup = 0;
            int i2 = 0;
            while (i2 < this.getMyTableDataObject().getFirstGroupIndices().size()) {
                ColumnGroupModel.ColumnGroup group = this.columnGroupModel.getColumnGroupByIndex(((Integer)this.getMyTableDataObject().getFirstGroupIndices().get(i2)).intValue());
                int iNumNonHidden = 0;
                List members = group.getMembers();
                int j = 0;
                while (j < members.size()) {
                    int iColLayerInx = (Integer)members.get(j);
                    int iColLayerPos = this.columnHeaderDataLayer.getColumnPositionByIndex(iColLayerInx);
                    String sHeaderKey = this.columnHeaderDataProvider.getDataKey(iColLayerPos, 0);
                    if (this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().hasColumn(sHeaderKey)) {
                        int iPrefColPos = this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().getVisColInx(sHeaderKey);
                        if (iPrefColPos != -1) {
                            ++iNumNonHidden;
                        }
                        if (i2 == 0) {
                            ++iNumVisFirstGroup;
                        }
                    }
                    ++j;
                }
                bTotalSuccess &= this.doReorderForExpGroup(this.columnHeaderDataLayer, this.columnHideShowLayer, group, i2 == 0 ? 0 : iNumVisFirstGroup, iNumNonHidden, i2, bAddSelect);
                ++i2;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        if (!bTotalSuccess) {
            logger.error((Object)"There is an error in the preference settings.");
            ErrorUtils.createErrorMessageBox((Shell)this.getShell(), (String)"Invalid Column Settings", (String)"Column preference settings were invalid. You may want to reconfigure them.   Please click \"Restore Defaults\" first.");
            return false;
        }
        return true;
    }

    private boolean doReorderForExpGroup(DataLayer columnLayer, ColumnHideShowLayer columnShowLayer, ColumnGroupModel.ColumnGroup group, int iNumFirstGroup, int iNumNonHidden, int iGroupNum, boolean bAddSelect) {
        List members = group.getMembers();
        int iAdder = iGroupNum > 0 ? (iGroupNum - 1) * iNumNonHidden : 0;
        iAdder += iNumFirstGroup;
        ArrayList<String> lProcessed = new ArrayList<String>();
        int iPrefColPos = 0;
        while (iPrefColPos < iNumNonHidden) {
            GRITSColumnHeader prefHeader = this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().getColumnAtVisColInx(Integer.valueOf(iPrefColPos + iNumFirstGroup));
            if (prefHeader != null) {
                int iMemInx = 0;
                while (iMemInx < members.size()) {
                    int iColLayerInx = (Integer)members.get(iMemInx);
                    int iColPos = this.columnHeaderDataLayer.getColumnPositionByIndex(iColLayerInx);
                    int iFromPos = LayerUtil.convertColumnPosition((ILayer)this.columnHeaderDataLayer, (int)iColPos, (IUniqueIndexLayer)this.columnHideShowLayer);
                    String sThisHeaderKey = this.columnHeaderDataProvider.getDataKey(iColPos, 0);
                    if (prefHeader.getKeyValue().equals(sThisHeaderKey)) {
                        int iToPos = iPrefColPos + iAdder;
                        if (bAddSelect) {
                            ++iToPos;
                        }
                        if (iFromPos + iAdder != iToPos) {
                            ColumnReorderCommand command = new ColumnReorderCommand((ILayer)this.columnHideShowLayer, iFromPos, iToPos);
                            this.columnHideShowLayer.doCommand((ILayerCommand)command);
                        }
                        lProcessed.add(sThisHeaderKey);
                        break;
                    }
                    ++iMemInx;
                }
            }
            ++iPrefColPos;
        }
        return lProcessed.size() == iNumNonHidden;
    }

    public void updatePreferenceSettingsFromCurrentView() {
        if (this.columnGroupModel == null || this.columnGroupModel.isEmpty()) {
            super.updatePreferenceSettingsFromCurrentView();
            return;
        }
        if (this.columnHeaderDataLayer == null || this.columnHeaderDataLayer.getColumnCount() == 0) {
            return;
        }
        if (this.getMyTableDataObject().getFirstGroupIndices() == null) {
            this.getMyTableDataObject().discoverGroups(this.columnGroupModel);
        }
        this.setVisibilityOfGroups(this.columnHeaderDataLayer, this.columnHideShowLayer, this.columnGroupModel, 0);
        this.setVisibilityOfGroups(this.columnHeaderDataLayer, this.columnHideShowLayer, this.columnGroupModel, 1);
    }

    private void setVisibilityOfGroups(DataLayer columnLayer, ColumnHideShowLayer columnShowLayer, ColumnGroupModel groupModel, int iGroupNum) {
        int iAdder = iGroupNum > 0 ? groupModel.getColumnGroupByIndex(0).getSize() : 0;
        ColumnGroupModel.ColumnGroup group = groupModel.getColumnGroupByIndex(((Integer)this.getMyTableDataObject().getFirstGroupIndices().get(iGroupNum)).intValue());
        List members = group.getMembers();
        int iNewNumCols = 0;
        int iMemInx = 0;
        while (iMemInx < members.size()) {
            int iColInx = (Integer)members.get(iMemInx);
            boolean bHidden = columnShowLayer.isColumnIndexHidden(iColInx);
            if (!bHidden) {
                ++iNewNumCols;
            }
            ++iMemInx;
        }
        int iToPos = iAdder;
        int iVisPos = 0;
        while (iVisPos < iNewNumCols) {
            int iColPos = LayerUtil.convertColumnPosition((ILayer)this.columnHideShowLayer, (int)(iVisPos + iAdder), (IUniqueIndexLayer)this.columnHeaderDataLayer);
            String sHeaderKey = this.columnHeaderDataProvider.getDataKey(iColPos, 0);
            if (this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().hasColumn(sHeaderKey)) {
                GRITSColumnHeader header = this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().getColumnHeader(sHeaderKey);
                this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().setVisColInx(header, Integer.valueOf(iToPos++));
            }
            ++iVisPos;
        }
        int iMemInx2 = 0;
        while (iMemInx2 < members.size()) {
            int iColInx = (Integer)members.get(iMemInx2);
            boolean bHidden = columnShowLayer.isColumnIndexHidden(iColInx);
            if (bHidden) {
                int iColPos = this.columnHeaderDataLayer.getColumnPositionByIndex(iColInx);
                String sHeaderKey = this.columnHeaderDataProvider.getDataKey(iColPos, 0);
                if (this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().hasColumn(sHeaderKey)) {
                    GRITSColumnHeader header = this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().getColumnHeader(sHeaderKey);
                    this.getGRITSTableDataObject().getTablePreferences().getPreferenceSettings().setVisColInx(header, Integer.valueOf(-1));
                }
            }
            ++iMemInx2;
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        logger.debug((Object)"Double click on the table");
        if (!(this.getTableDataProcessor() instanceof MSGlycanAnnotationReportTableDataProcessor) || !this.hasColumnGroupHeader()) {
            logger.error((Object)"Double-click on a non-merge table??");
            return;
        }
        GridLayer gl = (GridLayer)this.getLayer();
        int origRow = gl.getRowPositionByY(e.y);
        if (origRow < 2) {
            return;
        }
        int origCol = gl.getColumnPositionByX(e.x);
        if (origCol < 1) {
            return;
        }
        int iRowPostion = LayerUtil.convertRowPosition((ILayer)gl, (int)origRow, (IUniqueIndexLayer)this.getBottomDataLayer());
        int iColPostion = LayerUtil.convertColumnPosition((ILayer)gl, (int)origCol, (IUniqueIndexLayer)this.getBottomDataLayer());
        MSGlycanAnnotationReportTableDataProcessor proc = (MSGlycanAnnotationReportTableDataProcessor)this.getTableDataProcessor();
        Object oColHeader = ((ArrayList)proc.getSimianTableDataObject().getTableHeader().get(0)).get(iColPostion);
        if (!(oColHeader instanceof GRITSColumnHeader)) {
            logger.error((Object)"Wrong type when expecting String for experiment name.");
            return;
        }
        GRITSColumnHeader header = (GRITSColumnHeader)oColHeader;
        int iExpNum = -1;
        MergeSettings settings = proc.getMergeReportSettings();
        int i = 0;
        while (i < settings.getExperimentList().size()) {
            ExperimentAnnotation exp = (ExperimentAnnotation)settings.getExperimentList().get(i);
            if (exp.getAnnotationEntryId().toString().equals(header.getKeyValue())) {
                logger.debug((Object)("Found the experiment: " + exp.getAnnotationEntryId()));
                iExpNum = i;
                break;
            }
            ++i;
        }
        if (iExpNum < 0) {
            logger.error((Object)"Unable to locate experiment!");
            return;
        }
        Object scanObj = this.getBottomDataLayer().getDataValueByPosition(((Integer)this.getMyTableDataObject().getParentNoCol().get(iExpNum)).intValue(), iRowPostion);
        int iSourceScanNum = -1;
        try {
            iSourceScanNum = Integer.parseInt(scanObj.toString());
        }
        catch (NumberFormatException ex) {
            logger.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        Object peakObj = this.getBottomDataLayer().getDataValueByPosition(((Integer)this.getMyTableDataObject().getSourcePeakIdCol().get(iExpNum)).intValue(), iRowPostion);
        int iSourcePeakId = -1;
        try {
            iSourcePeakId = Integer.parseInt(peakObj.toString());
        }
        catch (NumberFormatException ex) {
            logger.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        if (iSourceScanNum == -1 && iSourcePeakId == -1) {
            logger.error((Object)"Unable to find souce scan number or peak id.");
            return;
        }
        if (iSourceScanNum != -1) {
            iSourcePeakId = -1;
        }
        ExperimentAnnotation mergeExp = (ExperimentAnnotation)settings.getExperimentList().get(iExpNum);
        Entry annotEntry = MSAnnotationMultiPageViewer.getEntryByAnnotationId((String)mergeExp.getAnnotationEntryId().toString());
        MSGlycanAnnotationReportMultiPageViewer viewer = MSGlycanAnnotationReportMultiPageViewer.getActiveViewer(this.parentView.getParentEditor().getContext());
        viewer.selectMSGlycanAnnotationEntry(annotEntry);
        this.showMSOverview(annotEntry);
        MSGlycanAnnotationMultiPageViewer msAnnotView1 = MSGlycanAnnotationMultiPageViewer.getActiveViewer((IEclipseContext)this.parentView.getParentEditor().getContext());
        int iFirstScanNum = -1;
        MSAnnotationTable msTable = (MSAnnotationTable)msAnnotView1.getScansView().getViewBase().getNatTable();
        MSAnnotationTableDataObject tdo = (MSAnnotationTableDataObject)msTable.getGRITSTableDataObject();
        if (tdo.getScanNoCols() != null && !tdo.getScanNoCols().isEmpty() && msTable.getBottomDataLayer().getDataValueByPosition(((Integer)tdo.getScanNoCols().get(0)).intValue(), 0) != null) {
            Integer iScan = (Integer)msTable.getBottomDataLayer().getDataValueByPosition(((Integer)tdo.getScanNoCols().get(0)).intValue(), 0);
            iFirstScanNum = iScan;
        }
        msTable.performDoubleClickOnScan(iFirstScanNum, 0.0, -1, null, 1, Integer.valueOf(-1));
        MSGlycanAnnotationMultiPageViewer msAnnotView2 = MSGlycanAnnotationMultiPageViewer.getActiveViewer((IEclipseContext)this.parentView.getParentEditor().getContext());
        MSAnnotationTable msTable2 = (MSAnnotationTable)((MassSpecPeaksView)msAnnotView2.getPeaksView().get(0)).getViewBase().getNatTable();
        MSAnnotationTableDataObject tdo2 = (MSAnnotationTableDataObject)msTable2.getGRITSTableDataObject();
        int i2 = 0;
        while (i2 < msTable2.getBottomDataLayer().getRowCount()) {
            Object targetScanObj = msTable2.getBottomDataLayer().getDataValueByPosition(((Integer)tdo2.getScanNoCols().get(0)).intValue(), i2);
            int iTargetScanNum = -1;
            try {
                iTargetScanNum = Integer.parseInt(targetScanObj.toString());
            }
            catch (NumberFormatException ex) {
                logger.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            if (iTargetScanNum == -1) {
                logger.error((Object)"Unable to find scan number source table. Can't continue.");
                return;
            }
            Object targetPeakObj = msTable2.getBottomDataLayer().getDataValueByPosition(((Integer)tdo2.getPeakIdCols().get(0)).intValue(), i2);
            int iTargetPeakId = -1;
            try {
                iTargetPeakId = Integer.parseInt(targetPeakObj.toString());
            }
            catch (NumberFormatException ex) {
                logger.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            if (iSourceScanNum != -1 && iTargetScanNum == iSourceScanNum || iSourcePeakId != -1 && iTargetPeakId == iSourcePeakId) {
                Object annotObj;
                if (tdo2.getAnnotationIdCols() != null && !tdo2.getAnnotationIdCols().isEmpty() && (annotObj = msTable2.getBottomDataLayer().getDataValueByPosition(((Integer)tdo2.getAnnotationIdCols().get(0)).intValue(), i2)) != null) {
                    try {
                        Integer.parseInt(annotObj.toString());
                    }
                    catch (NumberFormatException ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                        return;
                    }
                }
                msTable2.performMouseDown(i2);
                break;
            }
            ++i2;
        }
    }

    protected void showMSOverview(Entry newEntry) {
        ViewMSOverviewFromMergeCommandExecutor.showMSOverview(this.parentView.getParentEditor().getContext(), newEntry);
    }
}

