/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.grits.toolbox.editor.experimentdesigner.commands.ConnectionCreateCommand;
import org.grits.toolbox.editor.experimentdesigner.commands.ConnectionReconnectCommand;
import org.grits.toolbox.editor.experimentdesigner.model.Connection;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.InputNode;
import org.grits.toolbox.editor.experimentdesigner.model.ModelElement;
import org.grits.toolbox.editor.experimentdesigner.model.OutputNode;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.parts.GraphNodeComponentEditPolicy;
import org.grits.toolbox.editor.experimentdesigner.parts.InputOutputFigure;
import org.grits.toolbox.editor.experimentdesigner.parts.ProtocolFigure;

public class GraphNodeEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
NodeEditPart {
    private ConnectionAnchor anchor;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new GraphNodeComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new GraphicalNodeEditPolicy(){

            protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
                ConnectionCreateCommand cmd = (ConnectionCreateCommand)request.getStartCommand();
                cmd.setTarget((GraphNode)this.getHost().getModel());
                return cmd;
            }

            protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
                GraphNode source = (GraphNode)this.getHost().getModel();
                int style = (Integer)request.getNewObjectType();
                ConnectionCreateCommand cmd = new ConnectionCreateCommand(source, style);
                request.setStartCommand((Command)cmd);
                return cmd;
            }

            protected Command getReconnectSourceCommand(ReconnectRequest request) {
                Connection conn = (Connection)request.getConnectionEditPart().getModel();
                GraphNode newSource = (GraphNode)this.getHost().getModel();
                ConnectionReconnectCommand cmd = new ConnectionReconnectCommand(conn);
                cmd.setNewSource(newSource);
                return cmd;
            }

            protected Command getReconnectTargetCommand(ReconnectRequest request) {
                Connection conn = (Connection)request.getConnectionEditPart().getModel();
                GraphNode newTarget = (GraphNode)this.getHost().getModel();
                ConnectionReconnectCommand cmd = new ConnectionReconnectCommand(conn);
                cmd.setNewTarget(newTarget);
                return cmd;
            }
        });
    }

    protected IFigure createFigure() {
        IFigure f = this.createFigureForModel();
        f.setOpaque(true);
        return f;
    }

    private IFigure createFigureForModel() {
        Object model = this.getModel();
        if (model instanceof ProtocolNode) {
            ProtocolFigure fig = new ProtocolFigure();
            fig.getLabel().setText(((ProtocolNode)model).getLabel());
            fig.setBackgroundColor(((ProtocolNode)model).getColor());
            return fig;
        }
        if (model instanceof InputNode) {
            InputOutputFigure fig = new InputOutputFigure();
            fig.getLabel().setText(((InputNode)model).getLabel());
            fig.setBackgroundColor(((InputNode)model).getColor());
            return fig;
        }
        if (model instanceof OutputNode) {
            InputOutputFigure fig = new InputOutputFigure();
            fig.getLabel().setText(((OutputNode)model).getLabel());
            fig.setBackgroundColor(((OutputNode)model).getColor());
            return fig;
        }
        throw new IllegalArgumentException();
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    private GraphNode getCastedModel() {
        return (GraphNode)this.getModel();
    }

    protected ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            if (this.getModel() instanceof InputNode || this.getModel() instanceof OutputNode) {
                this.anchor = new EllipseAnchor(this.getFigure());
            } else if (this.getModel() instanceof ProtocolNode) {
                this.anchor = new ChopboxAnchor(this.getFigure());
            } else {
                throw new IllegalArgumentException("unexpected model");
            }
        }
        return this.anchor;
    }

    protected List getModelSourceConnections() {
        return this.getCastedModel().getSourceConnections();
    }

    protected List getModelTargetConnections() {
        return this.getCastedModel().getTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        IFigure figure;
        String prop = evt.getPropertyName();
        if ("Node.Size".equals(prop) || "Node.Location".equals(prop)) {
            this.refreshVisuals();
        } else if ("Node.SourceConn".equals(prop)) {
            this.refreshSourceConnections();
        } else if ("Node.TargetConn".equals(prop)) {
            this.refreshTargetConnections();
        } else if ("Node.Label".equals(prop) && (figure = this.getFigure()) instanceof ProtocolFigure) {
            ((ProtocolFigure)figure).getLabel().setText(((ProtocolNode)this.getModel()).getLabel());
            figure.repaint();
        }
    }

    protected void refreshVisuals() {
        Rectangle bounds = new Rectangle(this.getCastedModel().getLocation(), this.getCastedModel().getSize());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
    }

    public void updateBoundsForModel() {
        this.getCastedModel().setSize(new Dimension(this.getFigure().getBounds().getSize().width, this.getCastedModel().getSize().height));
    }
}

