/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table.manager;

import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyResolver;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.model.view.GeneView;

public class GeneListTableConfigLabelAccumulator
implements IConfigLabelAccumulator {
    private IColumnPropertyResolver columnPropertyAccessor;
    private ListDataProvider<TableData> bodyDataProvider;

    public GeneListTableConfigLabelAccumulator(ListDataProvider<TableData> bodyDataProvider, IColumnPropertyAccessor<TableData> columnPropertyAccessor) {
        this.bodyDataProvider = bodyDataProvider;
        this.columnPropertyAccessor = columnPropertyAccessor;
    }

    public void accumulateConfigLabels(LabelStack configLabels, int columnIndex, int rowIndex) {
        TableData element = (TableData)this.bodyDataProvider.getRowObject(rowIndex);
        String columnName = this.getColumnProperty(columnIndex);
        if (columnName == null) {
            return;
        }
        switch (columnName) {
            case "Select": {
                configLabels.addLabel("Selected");
            }
            case "Gene Identifier": {
                configLabels.addLabel("editable");
                break;
            }
            case "Gene Symbol": {
                configLabels.addLabel("editable");
                break;
            }
            case "ID": {
                configLabels.addLabel("integerEditable");
                break;
            }
            case "Name": {
                configLabels.addLabel("editable");
                if (!(element instanceof GeneView) || !((GeneView)element).isUpdated() || !((GeneView)element).getUpdatedFields().contains("Name")) break;
                configLabels.addLabel("redBackground");
                break;
            }
            case "Forward Primer": {
                configLabels.addLabel("editable");
                break;
            }
            case "Reverse Primer": {
                configLabels.addLabel("editable");
                break;
            }
            case "Description": {
                configLabels.addLabel("editable");
                break;
            }
            case "RefSeq": {
                configLabels.addLabel("editable");
                if (!(element instanceof GeneView) || !((GeneView)element).isUpdated() || !((GeneView)element).getUpdatedFields().contains("RefSeq")) break;
                configLabels.addLabel("redBackground");
                break;
            }
            case "Group": {
                configLabels.addLabel("editable");
                break;
            }
            case "Notes": {
                configLabels.addLabel("editable");
                break;
            }
            case "Aliases": {
                configLabels.addLabel("editable");
                if (!(element instanceof GeneView) || !((GeneView)element).isUpdated() || !((GeneView)element).getUpdatedFields().contains("Aliases")) break;
                configLabels.addLabel("redBackground");
                break;
            }
            case "Genomic Location": {
                configLabels.addLabel("editable");
                if (!(element instanceof GeneView) || !((GeneView)element).isUpdated() || !((GeneView)element).getUpdatedFields().contains("Genomic Location")) break;
                configLabels.addLabel("redBackground");
                break;
            }
            case "Protein RefSeq": {
                configLabels.addLabel("editable");
                if (!(element instanceof GeneView) || !((GeneView)element).isUpdated() || !((GeneView)element).getUpdatedFields().contains("Protein RefSeq")) break;
                configLabels.addLabel("redBackground");
                break;
            }
            case "Control?": {
                configLabels.addLabel("comboEditable");
            }
        }
    }

    private String getColumnProperty(int columnIndex) {
        return this.columnPropertyAccessor.getColumnProperty(columnIndex);
    }
}

