/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.entry.qrtpcr.editor.QrtPCRTableEditor;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRPreferencePage;
import org.grits.toolbox.entry.qrtpcr.table.QrtPCRNatTable;

public class PlateTableBase {
    Boolean rawData = true;
    Double lowerThreshold = QrtPCRPreferencePage.THRESHOLD_PREFERENCE;
    Double stDevCutOff = QrtPCRPreferencePage.STDEVCUTOFF_PREFERENCE;
    QrtPCRData data;
    private QrtPCRTableEditor editor;
    private Integer runId;

    public PlateTableBase(QrtPCRTableEditor editor) {
        this.editor = editor;
    }

    public void setLowerThreshold(Double lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
    }

    public void setStDevCutOff(Double stDevCutOff) {
        this.stDevCutOff = stDevCutOff;
    }

    public void setRawData(boolean rawData) {
        this.rawData = rawData;
    }

    public void setData(QrtPCRData data) {
        this.data = data;
    }

    public Control createControl(Composite parent) {
        ArrayList<List<GRITSColumnHeader>> columnList = new ArrayList<List<GRITSColumnHeader>>();
        ArrayList<GRITSColumnHeader> firstLevelColumns = new ArrayList<GRITSColumnHeader>();
        this.addColumns(firstLevelColumns);
        columnList.add(firstLevelColumns);
        ArrayList<TableData> allData = new ArrayList<TableData>();
        for (Gene gene : this.data.getGenes()) {
            allData.add(gene);
            allData.addAll((Collection<TableData>)gene.getDataMap().get(0));
        }
        QrtPCRNatTable natTable = new QrtPCRNatTable(parent, this.editor, columnList);
        natTable.setTableData(allData);
        natTable.setLowerThreshold(this.lowerThreshold);
        natTable.setStDevCutOff(this.stDevCutOff);
        natTable.setRawData(this.rawData);
        natTable.setRunId(this.runId);
        natTable.setQrtPCRData(this.data);
        natTable.initializeComponents();
        return natTable;
    }

    private void addColumns(List<GRITSColumnHeader> columnList) {
        GRITSColumnHeader header = new GRITSColumnHeader("Well", "Well");
        columnList.add(header);
        header = new GRITSColumnHeader("Gene Identifier", "Gene Identifier");
        columnList.add(header);
        header = new GRITSColumnHeader("ct0", "ct0");
        columnList.add(header);
        header = new GRITSColumnHeader("StDev", "StDev");
        columnList.add(header);
        header = new GRITSColumnHeader("2^-ct", "2^-ct");
        columnList.add(header);
        header = new GRITSColumnHeader("Norm Value", "Norm Value");
        columnList.add(header);
        header = new GRITSColumnHeader("Normalized", "Normalized");
        columnList.add(header);
        header = new GRITSColumnHeader("Scaler", "Scaler");
        columnList.add(header);
        header = new GRITSColumnHeader("Adjusted", "Adjusted");
        columnList.add(header);
        header = new GRITSColumnHeader("Average", "Average");
        columnList.add(header);
        header = new GRITSColumnHeader("St Dev - Adjusted", "St Dev - Adjusted");
        columnList.add(header);
    }

    public void setRunId(Integer runId) {
        this.runId = runId;
    }
}

