/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.preference;

import org.apache.log4j.Logger;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;

public class QrtPCRPreferencePage
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(QrtPCRPreferencePage.class);
    public static Double THRESHOLD_PREFERENCE = 35.0;
    public static Double STDEVCUTOFF_PREFERENCE = 0.5;
    public static String PREFERENCE_NAME_THRESHOLD = String.valueOf(QrtPCRPreferencePage.class.getName()) + ".threshold";
    public static String PREFERENCE_NAME_STDEVCUTOFF = String.valueOf(QrtPCRPreferencePage.class.getName()) + ".stdevcutoff";
    private Text thresholdText;
    private Text stDevCutoffText;
    private ControlDecoration dec;
    private ControlDecoration dec2;

    public static void loadPreferences() {
        QrtPCRPreferencePage.initThreshold();
        QrtPCRPreferencePage.initStDevCutOff();
    }

    private static void initThreshold() {
        try {
            try {
                PreferenceEntity preferenceEntity = PreferenceReader.getPreferenceByName((String)PREFERENCE_NAME_THRESHOLD);
                if (preferenceEntity != null) {
                    THRESHOLD_PREFERENCE = QrtPCRPreferencePage.getDoubleValue(preferenceEntity.getValue());
                }
            }
            catch (UnsupportedVersionException uEx) {
                logger.error((Object)"This version is not supported!", (Throwable)uEx);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Error getting the Preference variable for Number Of Components", (Throwable)ex);
        }
    }

    private static void initStDevCutOff() {
        try {
            try {
                PreferenceEntity preferenceEntity = PreferenceReader.getPreferenceByName((String)PREFERENCE_NAME_STDEVCUTOFF);
                if (preferenceEntity != null) {
                    STDEVCUTOFF_PREFERENCE = QrtPCRPreferencePage.getDoubleValue(preferenceEntity.getValue());
                }
            }
            catch (UnsupportedVersionException uEx) {
                logger.error((Object)"This version is not supported!", (Throwable)uEx);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Error getting the Preference variable for Number Of Components", (Throwable)ex);
        }
    }

    private static double getDoubleValue(String value) {
        double doubleValue = 1.0;
        try {
            doubleValue = value == null ? doubleValue : Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            logger.error((Object)("Could not parse the threshold/stdevcutoff value from the workspace. " + value + "\n" + ex.getMessage()), (Throwable)ex);
        }
        return doubleValue;
    }

    protected Control createContents(Composite parent) {
        QrtPCRPreferencePage.loadPreferences();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 20;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label thresholdLabel = new Label(container, 16385);
        thresholdLabel.setText("Maximum Cycles");
        thresholdLabel.setToolTipText("Default value for the threshold. If any of the values are bigger than the threshold they will be set to the threshold");
        this.thresholdText = new Text(container, 2049);
        this.thresholdText.setText("" + THRESHOLD_PREFERENCE);
        this.dec = new ControlDecoration((Control)this.thresholdText, 0x1000000);
        Image image = JFaceResources.getImage((String)"dialog_message_error_image");
        this.dec.setImage(image);
        this.dec.setDescriptionText("Should enter a positive floating point");
        this.dec.hide();
        this.thresholdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text newText = (Text)e.widget;
                String newValue = newText.getText();
                if (newValue != null) {
                    newValue = newValue.trim();
                }
                try {
                    Double newDouble = Double.parseDouble(newValue);
                    if (newDouble <= 0.0) {
                        QrtPCRPreferencePage.this.dec.show();
                    } else {
                        THRESHOLD_PREFERENCE = newDouble;
                        QrtPCRPreferencePage.this.dec.hide();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    QrtPCRPreferencePage.this.dec.show();
                }
            }
        });
        Label stDevLabel = new Label(container, 16385);
        stDevLabel.setText("Maximum Standard Deviation");
        stDevLabel.setToolTipText("Standard Deviation cut-off value. Entries having standard deviations more than this cutoff will be highlighted");
        this.stDevCutoffText = new Text(container, 2049);
        this.stDevCutoffText.setText("" + STDEVCUTOFF_PREFERENCE);
        this.dec2 = new ControlDecoration((Control)this.stDevCutoffText, 0x1000000);
        this.dec2.setImage(image);
        this.dec2.setDescriptionText("Should enter a positive floating point number");
        this.dec2.hide();
        this.stDevCutoffText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text newText = (Text)e.widget;
                String newValue = newText.getText();
                if (newValue != null) {
                    newValue = newValue.trim();
                }
                try {
                    Double newDouble = Double.parseDouble(newValue);
                    if (newDouble <= 0.0) {
                        QrtPCRPreferencePage.this.dec2.show();
                    } else {
                        STDEVCUTOFF_PREFERENCE = newDouble;
                        QrtPCRPreferencePage.this.dec2.hide();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    QrtPCRPreferencePage.this.dec2.show();
                }
            }
        });
        return container;
    }

    public boolean performOk() {
        return this.save();
    }

    private boolean save() {
        PreferenceEntity preferenceEntity1 = new PreferenceEntity(PREFERENCE_NAME_THRESHOLD);
        preferenceEntity1.setValue("" + THRESHOLD_PREFERENCE);
        PreferenceEntity preferenceEntity2 = new PreferenceEntity(PREFERENCE_NAME_STDEVCUTOFF);
        preferenceEntity2.setValue("" + STDEVCUTOFF_PREFERENCE);
        return PreferenceWriter.savePreference((PreferenceEntity)preferenceEntity1) && PreferenceWriter.savePreference((PreferenceEntity)preferenceEntity2);
    }

    protected void performDefaults() {
        this.thresholdText.setText("35.0");
        this.stDevCutoffText.setText("0.5");
    }
}

