/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.dialogs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.qrtpcr.dialogs.CustomSelectionDialogWithDescription;
import org.grits.toolbox.entry.qrtpcr.dialogs.UploadDataWizard;
import org.grits.toolbox.entry.qrtpcr.dialogs.UploadqrtPCRDataDialogPageTwo;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;
import org.grits.toolbox.entry.qrtpcr.model.Plate;
import org.grits.toolbox.entry.qrtpcr.model.PlateLayout;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRTable;
import org.grits.toolbox.entry.qrtpcr.model.Well;
import org.grits.toolbox.entry.qrtpcr.util.FileUtils;
import org.grits.toolbox.entry.qrtpcr.util.GeneUtils;

public class UploadqrtPCRDataDialogPageOne
extends WizardPage {
    private static final Logger logger = Logger.getLogger(UploadqrtPCRDataDialogPageOne.class);
    Entry sampleEntry = null;
    boolean forRerun = false;
    private Text plateLayout = null;
    private Combo controlGeneCombo = null;
    boolean replicatesValid = true;
    String[] plateIds;
    QrtPCRTable table;
    Text selectedDescription;
    PlateLayout layout = null;

    protected UploadqrtPCRDataDialogPageOne(String pageName, boolean forRerun) {
        super(pageName);
        this.forRerun = forRerun;
    }

    public void createControl(final Composite parent) {
        this.setTitle("Select a plate layout and upload files");
        this.setMessage("Please select a plate layout");
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(3, false));
        new Label(content, 0);
        new Label(content, 0);
        new Label(content, 0);
        Label lblPlatelayoutFile = new Label(content, 0);
        lblPlatelayoutFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPlatelayoutFile.setText("PlateLayout File");
        this.plateLayout = new Text(content, 2048);
        GridData gd_plateLayout = new GridData(4, 0x1000000, true, false, 1, 1);
        this.plateLayout.setLayoutData((Object)gd_plateLayout);
        this.plateLayout.setEditable(false);
        Button btnNewButton_1 = new Button(content, 0);
        btnNewButton_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void widgetSelected(SelectionEvent e) {
                void var2_4;
                ArrayList arrayList = new ArrayList();
                try {
                    List<PlateLayout> list = FileUtils.getAllPlateLayouts();
                }
                catch (IOException ex) {
                    Logger.getLogger(FileUtils.class).error((Object)"Error loading existing plate layouts", (Throwable)ex);
                    MessageDialog.openError((Shell)parent.getShell(), (String)"Error", (String)"Error loading existing plate layouts");
                }
                CustomSelectionDialogWithDescription dialog = new CustomSelectionDialogWithDescription(Display.getCurrent().getActiveShell(), false, null, (List<?>)var2_4);
                dialog.initializeGeneListSelectionDialog();
                if (dialog.open() == 0) {
                    UploadqrtPCRDataDialogPageOne.this.layout = (PlateLayout)dialog.getSelection();
                    try {
                        if (UploadqrtPCRDataDialogPageOne.this.forRerun) {
                            UploadqrtPCRDataDialogPageOne.this.sampleEntry = ((UploadDataWizard)UploadqrtPCRDataDialogPageOne.this.getWizard()).getSampleEntry();
                        }
                        String filename = String.valueOf(FileUtils.getPlateLayoutFolder()) + File.separator + UploadqrtPCRDataDialogPageOne.this.layout.getFilename();
                        String newFilename = FileUtils.copyFileIntoWorkspace(UploadqrtPCRDataDialogPageOne.this.sampleEntry, filename);
                        UploadqrtPCRDataDialogPageOne.this.plateLayout.setText(newFilename);
                        if (!UploadqrtPCRDataDialogPageOne.this.processFiles(UploadqrtPCRDataDialogPageOne.this.layout, newFilename, parent.getShell())) return;
                        UploadqrtPCRDataDialogPageOne.this.setPageComplete(true);
                        return;
                    }
                    catch (IOException e1) {
                        logger.error((Object)"Cannot copy the file into the workspace", (Throwable)e1);
                        ErrorUtils.createErrorMessageBox((Shell)UploadqrtPCRDataDialogPageOne.this.getShell(), (String)"Cannot copy the file into the workspace", (Exception)e1);
                        return;
                    }
                } else {
                    UploadqrtPCRDataDialogPageOne.this.setPageComplete(false);
                }
            }
        });
        btnNewButton_1.setText("Browse");
        this.setControl((Control)content);
        new Label(content, 0);
        this.controlGeneCombo = new Combo(content, 0);
        this.controlGeneCombo.setItems(new String[]{"<Select Control>"});
        this.controlGeneCombo.select(0);
        new Label(content, 0);
        this.setPageComplete(false);
    }

    protected List<String> findCommonGenes() {
        Map<String, QrtPCRData> dataMap = this.table.getPlateDataMap();
        ArrayList<String> commonGenes = new ArrayList<String>();
        for (QrtPCRData data : dataMap.values()) {
            List<Gene> genes = data.getGenes();
            for (Gene gene : genes) {
                if (!gene.getIsCommon().booleanValue() || commonGenes.contains(gene.getGeneIdentifier())) continue;
                commonGenes.add(gene.getGeneIdentifier());
            }
        }
        return commonGenes;
    }

    private void setupCommonGeneCombo() {
        int defaultSelection = -1;
        List<String> common = this.findCommonGenes();
        if (common.contains("HRPL4")) {
            defaultSelection = common.indexOf("HRPL4");
        }
        this.controlGeneCombo.setEnabled(true);
        this.controlGeneCombo.setItems(common.toArray(new String[common.size()]));
        this.controlGeneCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UploadqrtPCRDataDialogPageOne.this.setControlGene(UploadqrtPCRDataDialogPageOne.this.controlGeneCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                UploadqrtPCRDataDialogPageOne.this.setControlGene(UploadqrtPCRDataDialogPageOne.this.controlGeneCombo.getText());
            }
        });
        if (defaultSelection != -1) {
            this.controlGeneCombo.select(defaultSelection);
            this.setControlGene(this.controlGeneCombo.getText());
        }
    }

    private void setControlGene(String geneIdentifier) {
        Map<String, QrtPCRData> dataMap = this.table.getPlateDataMap();
        block0: for (QrtPCRData data : dataMap.values()) {
            List<Gene> genes = data.getGenes();
            for (Gene gene : genes) {
                if (!gene.getGeneIdentifier().equals(geneIdentifier)) continue;
                gene.setIsControl(true);
                continue block0;
            }
        }
    }

    public IWizardPage getNextPage() {
        UploadqrtPCRDataDialogPageTwo pageTwo = (UploadqrtPCRDataDialogPageTwo)this.getWizard().getPage("Data file");
        pageTwo.setPlateIds(this.plateIds);
        return pageTwo;
    }

    private boolean processFiles(PlateLayout layout, String plateLayoutFileName, Shell shell) {
        this.table = new QrtPCRTable();
        this.table.setPlateLayoutFile(plateLayoutFileName);
        this.plateIds = new String[layout.getPlates().size()];
        int i = 0;
        for (Plate plate : layout.getPlates()) {
            String plateId = plate.getPlateId();
            this.plateIds[i++] = plateId;
            QrtPCRData data = new QrtPCRData();
            ArrayList<Gene> geneList = new ArrayList<Gene>();
            data.setNumberOfReplicates(layout.getNumberOfReplicates());
            for (Well well : plate.getPlateMap().keySet()) {
                GeneData geneData;
                Gene gene = plate.getPlateMap().get(well);
                Gene existing = this.geneExistsInList(gene, geneList);
                if (existing == null) {
                    Gene geneForGeneList = GeneUtils.makeACopy(gene);
                    geneList.add(geneForGeneList);
                    geneData = new GeneData();
                    geneData.setGene(geneForGeneList);
                    geneData.setPlateId(plateId);
                    geneData.setPosition(well);
                    ArrayList<GeneData> geneDataList = new ArrayList<GeneData>();
                    geneDataList.add(geneData);
                    geneForGeneList.addGeneDataList(geneDataList);
                    geneForGeneList.setNumOfReplicates(1);
                    continue;
                }
                List<GeneData> geneDataList = existing.getDataMap().get(0);
                geneData = new GeneData();
                geneData.setGene(existing);
                geneData.setPlateId(plateId);
                geneData.setPosition(well);
                geneDataList.add(geneData);
                existing.setNumOfReplicates(geneDataList.size());
            }
            Collections.sort(geneList);
            data.setGenes(geneList);
            this.table.addData(plateId, data);
        }
        this.setupCommonGeneCombo();
        return true;
    }

    Gene geneExistsInList(Gene gene, List<Gene> list) {
        for (Gene existing : list) {
            if (!existing.getGeneIdentifier().equals(gene.getGeneIdentifier())) continue;
            return existing;
        }
        return null;
    }

    public String getMasterListFile() {
        return this.layout.getInputList().getFilename();
    }

    public String getPlateLayout() {
        return this.plateLayout.getText();
    }

    public String[] getPlateIds() {
        return this.plateIds;
    }

    public QrtPCRTable getTable() {
        return this.table;
    }

    public void setTable(QrtPCRTable table) {
        this.table = table;
    }

    public void setSampleEntry(Entry parentEntry) {
        this.sampleEntry = parentEntry;
    }
}

