/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.ReportsProperty;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.qrtpcr.dialogs.QrtPCRMergeReportDialog;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRRun;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRTable;
import org.grits.toolbox.entry.qrtpcr.model.merge.MergeData;
import org.grits.toolbox.entry.qrtpcr.model.merge.MergedQrtPCR;
import org.grits.toolbox.entry.qrtpcr.property.QrtPCRMergeProperty;
import org.grits.toolbox.entry.qrtpcr.property.QrtPCRProperty;
import org.grits.toolbox.entry.qrtpcr.util.FileUtils;

public class CreateMergeReport {
    private static final Logger logger = Logger.getLogger(CreateMergeReport.class);
    @Inject
    private static IGritsDataModelService gritsDataModelService = null;
    @Inject
    static IGritsUIService gritsUIService = null;

    @Execute
    public Object execute(@Named(value="org.eclipse.ui.selection") Object object, IEventBroker eventBroker, @Named(value="activeShell") Shell shell) throws ExecutionException {
        StructuredSelection to = null;
        Entry selectedEntry = null;
        if (object instanceof Entry) {
            selectedEntry = (Entry)object;
        } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
            to = (StructuredSelection)object;
        }
        if (selectedEntry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            to = gritsDataModelService.getLastSelection();
        }
        if (to == null) {
            if (selectedEntry != null) {
                if (selectedEntry.getProperty().getType().equals("org.grits.toolbox.property.qrtpcr")) {
                    ArrayList<Entry> entries = new ArrayList<Entry>();
                    entries.add(selectedEntry);
                    this.createMergeReportDialog(shell, entries, eventBroker);
                } else {
                    this.createMergeReportDialog(shell, null, eventBroker);
                }
            } else {
                this.createMergeReportDialog(shell, null, eventBroker);
            }
        } else {
            boolean correctEntries = true;
            ArrayList<Entry> entries = new ArrayList<Entry>();
            for (Entry qrtPCREntry : to) {
                if (qrtPCREntry.getProperty().getType().equals("org.grits.toolbox.property.qrtpcr")) {
                    entries.add(qrtPCREntry);
                    continue;
                }
                correctEntries = false;
                break;
            }
            if (correctEntries) {
                this.createMergeReportDialog(shell, entries, eventBroker);
            } else {
                this.createMergeReportDialog(shell, null, eventBroker);
            }
        }
        return null;
    }

    private void createMergeReportDialog(Shell activeShell, List<Entry> entries, IEventBroker eventBroker) {
        QrtPCRMergeReportDialog dialog = new QrtPCRMergeReportDialog(PropertyHandler.getModalDialog((Shell)activeShell), entries);
        if (dialog.open() == 0) {
            File reportsFolder;
            Shell modalDialog = PropertyHandler.getModalDialog((Shell)new Shell());
            String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
            Entry projectEntry = DataModelSearch.findParentByType((Entry)dialog.getQrtPCREntryList().get(0), (String)"org.grits.toolbox.property.project");
            String projectName = projectEntry.getDisplayName();
            Entry reportsEntry = null;
            for (Entry child : projectEntry.getChildren()) {
                if (!child.getProperty().getType().equals("org.grits.toolbox.property.reports")) continue;
                reportsEntry = child;
            }
            if (reportsEntry == null) {
                reportsEntry = new Entry();
                reportsEntry.setDisplayName("reports");
                reportsEntry.setProperty((Property)new ReportsProperty());
                try {
                    PropertyHandler.getDataModel().setShow(false);
                    gritsDataModelService.addEntry(projectEntry, reportsEntry);
                    try {
                        ProjectFileHandler.saveProject((Entry)projectEntry);
                    }
                    catch (IOException e) {
                        logger.error((Object)("Something went wrong while saving project entry \n" + e.getMessage()), (Throwable)e);
                        logger.fatal((Object)("Closing project entry \"" + projectEntry.getDisplayName() + "\""));
                        gritsDataModelService.closeProject(projectEntry);
                        throw e;
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    ErrorUtils.createErrorMessageBox((Shell)modalDialog, (String)e.getMessage(), (Exception)e);
                    return;
                }
            }
            if (!(reportsFolder = new File(String.valueOf(workspaceLocation) + projectName + File.separator + ReportsProperty.getFolder())).exists() && !reportsFolder.mkdirs()) {
                logger.error((Object)("Cannot create the folder: " + reportsFolder.getAbsolutePath()));
                ErrorUtils.createWarningMessageBox((Shell)modalDialog, (String)"Error While Creating A Folder", (String)("Cannot create the folder: " + reportsFolder.getAbsolutePath()));
                return;
            }
            File mergeFolder = new File(reportsFolder + File.separator + "qrtPCR");
            if (!mergeFolder.exists() && !mergeFolder.mkdirs()) {
                logger.error((Object)("Cannot create the folder: " + mergeFolder.getAbsolutePath()));
                ErrorUtils.createWarningMessageBox((Shell)modalDialog, (String)"Error While Creating A Folder", (String)("Cannot create the folder: " + mergeFolder.getAbsolutePath()));
                return;
            }
            Entry qrtPCRMergeEntry = dialog.createEntry();
            QrtPCRMergeProperty property = (QrtPCRMergeProperty)qrtPCRMergeEntry.getProperty();
            String qrtPCRMergeFileName = this.createQrtPCRMergeFile(mergeFolder, dialog.getQrtPCREntryList(), dialog.getName(), dialog.getDescription(), dialog.getListEntries());
            property.setFilename(qrtPCRMergeFileName);
            qrtPCRMergeEntry.setParent(reportsEntry);
            try {
                gritsDataModelService.addEntry(reportsEntry, qrtPCRMergeEntry);
                try {
                    ProjectFileHandler.saveProject((Entry)projectEntry);
                }
                catch (IOException e) {
                    logger.error((Object)("Something went wrong while saving project entry \n" + e.getMessage()), (Throwable)e);
                    logger.fatal((Object)("Closing project entry \"" + projectEntry.getDisplayName() + "\""));
                    gritsDataModelService.closeProject(projectEntry);
                    throw e;
                }
                if (qrtPCRMergeEntry != null) {
                    eventBroker.send("grits_entry_selected", (Object)qrtPCRMergeEntry);
                    gritsUIService.openEntryInPart(qrtPCRMergeEntry);
                }
            }
            catch (IOException e) {
                logger.error((Object)("Cannot add the merge report: " + qrtPCRMergeEntry.getDisplayName()), (Throwable)e);
                ErrorUtils.createErrorMessageBox((Shell)modalDialog, (String)"Error while adding merge report", (Exception)e);
                return;
            }
        }
    }

    private String createQrtPCRMergeFile(File mergeFolder, List<Entry> qrtPCREntryList, String name, String description, Map<String, String> aliasList) {
        String qrtPCRMergeFileName = CreateMergeReport.generateFileName(mergeFolder.list());
        try {
            MergedQrtPCR mergeData = this.createMergedData(qrtPCREntryList, name, description, aliasList);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MergedQrtPCR.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)mergeData, (OutputStream)os);
            FileWriter fileWriter = new FileWriter(String.valueOf(mergeFolder.getAbsolutePath()) + File.separator + qrtPCRMergeFileName);
            fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
            fileWriter.close();
            os.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException | JAXBException e) {
            logger.error((Object)("Cannot create the merge report: " + name), e);
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Error while creating merge report", (Exception)e);
        }
        catch (IOException e) {
            logger.error((Object)("Cannot save the merge report: " + name), (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Error while save merge report", (Exception)e);
        }
        return qrtPCRMergeFileName;
    }

    private MergedQrtPCR createMergedData(List<Entry> qrtPCREntryList, String name, String description, Map<String, String> aliasList) throws FileNotFoundException, UnsupportedEncodingException, JAXBException {
        MergedQrtPCR mergeQrtPCR = new MergedQrtPCR();
        mergeQrtPCR.setName(name);
        mergeQrtPCR.setDescription(description);
        mergeQrtPCR.setAliasList(aliasList);
        HashMap<Gene, List<MergeData>> mergeDataMap = new HashMap<Gene, List<MergeData>>();
        for (Entry entry : qrtPCREntryList) {
            QrtPCRRun run = FileUtils.loadQrtPCRRun(entry, ((QrtPCRProperty)entry.getProperty()).getFilename());
            mergeQrtPCR.setStDevCutOff(run.getStDevCutOff());
            QrtPCRTable qrtPCRTable = run.getFirstRun();
            for (String plateId : qrtPCRTable.getPlateDataMap().keySet()) {
                QrtPCRData data = qrtPCRTable.getData(plateId);
                for (Gene gene : data.getGenes()) {
                    List<MergeData> mergeDataList = null;
                    for (Gene gene2 : mergeDataMap.keySet()) {
                        if (!gene.getGeneIdentifier().equals(gene2.getGeneIdentifier())) continue;
                        mergeDataList = (List)mergeDataMap.get(gene2);
                        mergeDataMap.remove(gene2);
                        break;
                    }
                    if (mergeDataList == null) {
                        mergeDataList = new ArrayList();
                    }
                    MergeData mergeData = new MergeData();
                    mergeData.setEntryName(aliasList.get(entry.getDisplayName()));
                    mergeData.setAverage(gene.getAdjustedAverage(gene.getRunId(), run.getThreshold(), gene.getNormValue(gene.getRunId())));
                    mergeData.setStDev(gene.getStDevForAdjusted(gene.getRunId(), run.getThreshold(), gene.getNormValue(gene.getRunId())));
                    mergeDataList.add(mergeData);
                    mergeDataMap.put(gene, mergeDataList);
                }
            }
        }
        mergeQrtPCR.setQrtPCRGeneListMap(mergeDataMap);
        return mergeQrtPCR;
    }

    public static String generateFileName(String[] existingNames) {
        String fileName = "";
        int randomLength = 0;
        do {
            fileName = "qrtPCR";
            while (randomLength < 5) {
                int randomcharacter = (int)(Math.random() * 10.0);
                ++randomLength;
                fileName = String.valueOf(fileName) + randomcharacter;
            }
            fileName = String.valueOf(fileName) + ".xml";
        } while (Arrays.asList(existingNames).contains(fileName));
        return fileName;
    }
}

