/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.common.component;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.tools.emf.ui.common.AbstractElementEditorContribution;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.IdGenerator;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.ModelEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.properties.ProjectOSGiTranslationProvider;
import org.eclipse.e4.tools.services.IClipboardService;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractComponentEditor {
    private static final String GREY_SUFFIX = "Grey";
    private static final String CSS_CLASS_KEY = "org.eclipse.e4.ui.css.CssClassName";
    private final WritableValue master = new WritableValue();
    public static final int SEARCH_IMAGE = 0;
    public static final int TABLE_ADD_IMAGE = 1;
    public static final int TABLE_DELETE_IMAGE = 2;
    public static final int ARROW_UP = 3;
    public static final int ARROW_DOWN = 4;
    protected static final int VERTICAL_LIST_WIDGET_INDENT = 10;
    @Inject
    private EditingDomain editingDomain;
    @Inject
    private ModelEditor editor;
    @Inject
    public IResourcePool resourcePool;
    @Inject
    @Optional
    protected IProject project;
    @Inject
    @Translation
    protected Messages Messages;
    @Inject
    @Optional
    private ProjectOSGiTranslationProvider translationProvider;
    private Composite editorControl;
    private IdGenerator generator;

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public ModelEditor getEditor() {
        return this.editor;
    }

    public WritableValue getMaster() {
        return this.master;
    }

    protected void setElementId(Object element) {
        MApplicationElement el;
        if (this.getEditor().isAutoCreateElementId() && element instanceof MApplicationElement && ((el = (MApplicationElement)element).getElementId() == null || el.getElementId().trim().length() == 0)) {
            el.setElementId(Util.getDefaultElementId(((EObject)this.getMaster().getValue()).eResource(), el, this.getEditor().getProject()));
        }
    }

    public Image createImage(String key) {
        return this.resourcePool.getImageUnchecked(key);
    }

    public ImageDescriptor createImageDescriptor(String key) {
        if (key == null) {
            return null;
        }
        return ImageDescriptor.createFromImage((Image)this.createImage(key));
    }

    private ImageRegistry getComponentImages() {
        return this.editor.getComponentImages();
    }

    public Image getImageFromIconURI(MUILabel element) {
        boolean greyVersion;
        Image img = null;
        String iconUri = element.getIconURI();
        if (iconUri != null && iconUri.trim().length() > 0 && (img = this.getImage(iconUri, greyVersion = this.shouldBeGrey(element))) == null) {
            ImageDescriptor desc = this.getImageDescriptorFromUri(iconUri);
            this.getComponentImages().put(iconUri, desc);
            img = this.getImage(iconUri, greyVersion);
        }
        return img;
    }

    private boolean shouldBeGrey(Object element) {
        return element instanceof MUIElement && (!((MUIElement)element).isToBeRendered() || !((MUIElement)element).isVisible());
    }

    private Image getImage(String key, boolean grey) {
        Image result = this.getComponentImages().get(String.valueOf(key) + (grey ? GREY_SUFFIX : ""));
        if (result == null) {
            result = this.getComponentImages().get(key);
            if (result == null && !key.startsWith("platform:")) {
                try {
                    result = this.createImage(key);
                }
                catch (Exception exception) {}
                if (result != null) {
                    this.getComponentImages().put(key, result);
                }
            }
            if (result != null && grey) {
                Image greyImg = new Image(result.getDevice(), result, 2);
                this.getComponentImages().put(String.valueOf(key) + GREY_SUFFIX, greyImg);
                result = greyImg;
            }
        }
        return result;
    }

    public Image getImage(Object element, String key) {
        Image result = null;
        if (element instanceof MUILabel) {
            result = this.getImageFromIconURI((MUILabel)element);
        }
        if (result == null) {
            boolean greyVersion = this.shouldBeGrey(element);
            result = this.getImage(key, greyVersion);
        }
        return result;
    }

    private ImageDescriptor getImageDescriptorFromUri(String uri) {
        URL url;
        InputStream stream;
        ImageDescriptor result;
        block10: {
            result = null;
            stream = null;
            url = null;
            try {
                URL uri2url = new URL(uri);
                url = FileLocator.toFileURL((URL)uri2url);
                stream = url.openStream();
            }
            catch (IOException iOException) {
                url = null;
                if (!uri.startsWith("platform:/plugin")) break block10;
                try {
                    URL resUrl = new URL(uri.replace("platform:/plugin", "platform:/resource"));
                    url = FileLocator.toFileURL((URL)resUrl);
                    stream = url.openStream();
                }
                catch (IOException iOException2) {
                    try {
                        url = FileLocator.find((URL)new URL(uri));
                        stream = url != null ? url.openStream() : null;
                    }
                    catch (IOException iOException3) {
                        url = null;
                    }
                }
            }
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (url != null) {
            result = ImageDescriptor.createFromURL((URL)url);
        }
        return result;
    }

    public Image getImage(Object element) {
        return null;
    }

    public abstract String getLabel(Object var1);

    public abstract String getDetailLabel(Object var1);

    public abstract String getDescription(Object var1);

    public Composite getEditor(Composite parent, Object object) {
        if (this.generator != null) {
            this.generator.stopGenerating();
            this.generator = null;
        }
        this.editorControl = this.doGetEditor(parent, object);
        return this.editorControl;
    }

    protected abstract Composite doGetEditor(Composite var1, Object var2);

    public abstract IObservableList getChildList(Object var1);

    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[0];
    }

    public List<Action> getActions(Object element) {
        return Collections.emptyList();
    }

    public String translate(String string) {
        return ControlFactory.tr(this.translationProvider, string);
    }

    public List<Action> getActionsImport(Object element) {
        return Collections.emptyList();
    }

    protected String getLocalizedLabel(MUILabel element) {
        return ControlFactory.getLocalizedLabel(this.translationProvider, element);
    }

    private boolean isFocusChild(Control control) {
        Control c = control;
        while (c != null && c != this.editorControl) {
            c = c.getParent();
        }
        return c != null;
    }

    public void handleCopy() {
        Control focusControl;
        if (this.editorControl != null && this.isFocusChild(focusControl = this.editorControl.getDisplay().getFocusControl()) && focusControl.getData(ControlFactory.COPY_HANDLER) != null) {
            ((IClipboardService.Handler)focusControl.getData(ControlFactory.COPY_HANDLER)).copy();
        }
    }

    public void handlePaste() {
        Control focusControl;
        if (this.editorControl != null && this.isFocusChild(focusControl = this.editorControl.getDisplay().getFocusControl()) && focusControl.getData(ControlFactory.COPY_HANDLER) != null) {
            ((IClipboardService.Handler)focusControl.getData(ControlFactory.COPY_HANDLER)).paste();
        }
    }

    public void handleCut() {
        Control focusControl;
        if (this.editorControl != null && this.isFocusChild(focusControl = this.editorControl.getDisplay().getFocusControl()) && focusControl.getData(ControlFactory.COPY_HANDLER) != null) {
            ((IClipboardService.Handler)focusControl.getData(ControlFactory.COPY_HANDLER)).cut();
        }
    }

    protected Composite createScrollableContainer(Composite parent) {
        final ScrolledComposite scrolling = new ScrolledComposite(parent, 768);
        scrolling.setBackgroundMode(1);
        scrolling.setData(CSS_CLASS_KEY, (Object)"formContainer");
        final Composite contentContainer = new Composite((Composite)scrolling, 0);
        contentContainer.setData(CSS_CLASS_KEY, (Object)"formContainer");
        scrolling.setExpandHorizontal(true);
        scrolling.setExpandVertical(true);
        scrolling.setContent((Control)contentContainer);
        scrolling.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrolling.getClientArea();
                scrolling.setMinSize(contentContainer.computeSize(r.width, -1));
            }
        });
        scrolling.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(3, false);
        gl.horizontalSpacing = 10;
        contentContainer.setLayout((Layout)gl);
        return contentContainer;
    }

    protected void createContributedEditorTabs(CTabFolder folder, EMFDataBindingContext context, WritableValue master, Class<?> clazz) {
        List<AbstractElementEditorContribution> contributionList = this.editor.getTabContributionsForClass(clazz);
        for (AbstractElementEditorContribution eec : contributionList) {
            CTabItem item = new CTabItem(folder, 2048);
            item.setText(eec.getTabLabel());
            Composite parent = this.createScrollableContainer((Composite)folder);
            item.setControl((Control)parent.getParent());
            eec.createContributedEditorTab(parent, context, master, this.getEditingDomain(), this.project);
        }
    }

    protected void enableIdGenerator(EAttribute attSource, EAttribute attId, Control control) {
        if (this.generator != null) {
            this.generator.stopGenerating();
            this.generator = null;
        }
        if (this.getEditor().isAutoCreateElementId()) {
            this.generator = new IdGenerator();
            this.generator.bind((IObservableValue)this.getMaster(), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)attSource), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)attId), control);
        }
    }
}

