/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.forms;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class DatabaseInformationComposite {
    private static Integer TEXT_LENGTH_NAME_VERSION = 64;
    private static Integer TEXT_LENGTH_DESCRITION = 1024;
    private FormToolkit m_toolkit;
    private Text m_txtDBName;
    private Text m_txtDBVersion;
    private Text m_txtDesc;
    private String m_strErrorMessage;

    public DatabaseInformationComposite(Composite parent, FormToolkit toolkit) {
        this.m_toolkit = toolkit;
        this.createControls(parent);
    }

    public DatabaseInformationComposite(Composite parent) {
        this.m_toolkit = new FormToolkit(parent.getDisplay());
        this.m_toolkit.setBackground(parent.getBackground());
        this.createControls(parent);
    }

    private void createControls(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        Label lbl = this.m_toolkit.createLabel(parent, "Name");
        lbl.setLayoutData((Object)new TableWrapData(2, 32));
        this.m_txtDBName = this.m_toolkit.createText(parent, "", 2048);
        this.m_txtDBName.setLayoutData((Object)new TableWrapData(256, 32));
        this.m_txtDBName.setBackground(Display.getCurrent().getSystemColor(1));
        lbl = this.m_toolkit.createLabel(parent, "Version");
        lbl.setLayoutData((Object)new TableWrapData(2, 32));
        this.m_txtDBVersion = this.m_toolkit.createText(parent, "", 2048);
        this.m_txtDBVersion.setLayoutData((Object)new TableWrapData(256, 32));
        this.m_txtDBVersion.setBackground(Display.getCurrent().getSystemColor(1));
        lbl = this.m_toolkit.createLabel(parent, "Description");
        lbl.setLayoutData((Object)new TableWrapData(2, 16));
        this.m_txtDesc = this.m_toolkit.createText(parent, "", 2626);
        TableWrapData data = new TableWrapData(256, 256);
        data.maxWidth = 120;
        data.heightHint = 50;
        this.m_txtDesc.setLayoutData((Object)data);
        this.m_txtDesc.setBackground(Display.getCurrent().getSystemColor(1));
    }

    public void setDatabaseName(String strName) {
        this.m_txtDBName.setText(strName);
    }

    public String getDatabaseName() {
        return this.m_txtDBName.getText();
    }

    public void setDatabaseVersion(String strVersion) {
        this.m_txtDBVersion.setText(strVersion);
    }

    public String getDatabaseVersion() {
        return this.m_txtDBVersion.getText();
    }

    public String getDatabaseDescription() {
        return this.m_txtDesc.getText();
    }

    public void setDatabaseDescription(String strDesc) {
        this.m_txtDesc.setText(strDesc);
    }

    public boolean isEmpty() {
        return this.m_txtDBName.getText().isEmpty() || this.m_txtDBVersion.getText().isEmpty() || this.m_txtDesc.getText().isEmpty();
    }

    public void clearForm() {
        this.m_txtDBName.setText("");
        this.m_txtDBVersion.setText("");
        this.m_txtDesc.setText("");
    }

    private void setErrorMessage(String strMessage) {
        this.m_strErrorMessage = strMessage;
    }

    public String getErrorMessage() {
        return this.m_strErrorMessage;
    }

    public boolean isValidInput() {
        if (this.m_txtDBName.getText().isEmpty()) {
            this.setErrorMessage("Please provide a name for the database.");
            return false;
        }
        if (this.m_txtDBName.getText().length() > TEXT_LENGTH_NAME_VERSION) {
            this.setErrorMessage("The database name can not be longer than " + TEXT_LENGTH_NAME_VERSION.toString() + " characters.");
            return false;
        }
        if (this.m_txtDBVersion.getText().isEmpty()) {
            this.setErrorMessage("Please provide a version for the database.");
            return false;
        }
        if (this.m_txtDBVersion.getText().length() > TEXT_LENGTH_NAME_VERSION) {
            this.setErrorMessage("The database version can not be longer than " + TEXT_LENGTH_NAME_VERSION.toString() + " characters.");
            return false;
        }
        if (!this.m_txtDesc.getText().isEmpty() && this.m_txtDesc.getText().length() > TEXT_LENGTH_DESCRITION) {
            this.setErrorMessage("The description can not be longer than " + TEXT_LENGTH_DESCRITION.toString() + " characters.");
            return false;
        }
        this.setErrorMessage("");
        return true;
    }

    public void addModifyListener(ModifyListener listener) {
        this.m_txtDBName.addModifyListener(listener);
        this.m_txtDBVersion.addModifyListener(listener);
        this.m_txtDesc.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.m_txtDBName.removeModifyListener(listener);
        this.m_txtDBVersion.removeModifyListener(listener);
        this.m_txtDesc.removeModifyListener(listener);
    }
}

