/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.MassUtils;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.ResidueDictionary;

public class MassOptionsDialog
extends TitleAreaDialog {
    private MassOptions m_massOptions;
    private Combo m_cmbIsotope;
    private Combo m_cmbDeriv;
    private Combo m_cmbRedend;
    private Text m_txtRedendName;
    private Text m_txtRedendMass;
    private Button m_btnNegativeMode;
    private Map<String, Spinner> m_mapIonToSpinner;
    private Map<String, Spinner> m_mapExIonToSpinner;
    private static final int MAX_REDEND_NAME_LENGTH = 20;

    public MassOptionsDialog(Shell parentShell, MassOptions massOptions) {
        super(parentShell);
        this.m_massOptions = massOptions;
        if (this.m_massOptions == null) {
            this.m_massOptions = new MassOptions();
        }
    }

    public void create() {
        super.create();
        this.setTitle("Mass options");
    }

    public Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(4, true);
        container.setLayout((Layout)layout);
        this.createControls(container);
        this.setParameters(this.m_massOptions);
        return area;
    }

    private void createControls(Composite parent) {
        Label lbl = new Label(parent, 0);
        lbl.setText("Isotope");
        Combo cmb = new Combo(parent, 8);
        cmb.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)cmb);
        this.m_cmbIsotope = cmb;
        lbl = new Label(parent, 0);
        GridDataFactory.fillDefaults().span(2, 3).applyTo((Control)lbl);
        lbl = new Label(parent, 0);
        lbl.setText("Derivatization");
        cmb = new Combo(parent, 8);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)cmb);
        this.m_cmbDeriv = cmb;
        lbl = new Label(parent, 0);
        lbl.setText("Reducing end");
        cmb = new Combo(parent, 8);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)cmb);
        this.m_cmbRedend = cmb;
        lbl = new Label(parent, 0);
        GridDataFactory.fillDefaults().span(1, 2).applyTo((Control)lbl);
        lbl = new Label(parent, 0);
        lbl.setText("name");
        Text txt = new Text(parent, 2048);
        txt.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)txt);
        txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MassOptionsDialog.this.validate();
            }
        });
        this.m_txtRedendName = txt;
        lbl = new Label(parent, 0);
        lbl.setText("mass");
        txt = new Text(parent, 2048);
        txt.setText("0");
        txt.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)txt);
        txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MassOptionsDialog.this.validate();
            }
        });
        this.m_txtRedendMass = txt;
        this.m_cmbRedend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Combo)e.widget).getText().equals("Other...")) {
                    MassOptionsDialog.this.m_txtRedendName.setEnabled(true);
                    MassOptionsDialog.this.m_txtRedendMass.setEnabled(true);
                    MassOptionsDialog.this.validate();
                } else {
                    MassOptionsDialog.this.m_txtRedendName.setEnabled(false);
                    MassOptionsDialog.this.m_txtRedendMass.setEnabled(false);
                    MassOptionsDialog.this.setErrorMessage(null);
                }
            }
        });
        lbl = new Label(parent, 258);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(4, 1).applyTo((Control)lbl);
        Button btn = new Button(parent, 32);
        btn.setText("Negative mode");
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)btn);
        this.m_btnNegativeMode = btn;
        lbl = new Label(parent, 0);
        GridDataFactory.fillDefaults().span(2, 2).applyTo((Control)lbl);
        this.m_mapIonToSpinner = new HashMap<String, Spinner>();
        this.m_mapExIonToSpinner = new HashMap<String, Spinner>();
        this.createIonSpinnerControl(parent, "H");
        this.createIonSpinnerControl(parent, "Na");
        this.createIonSpinnerControl(parent, "Li");
        this.createIonSpinnerControl(parent, "K");
        lbl = new Label(parent, 258);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(4, 1).applyTo((Control)lbl);
        this.createIonSpinnerControl(parent, "Cl");
        this.createIonSpinnerControl(parent, "H2PO4");
    }

    private Spinner getDefaultSpinner(Composite parent) {
        Spinner spn = new Spinner(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)spn);
        return spn;
    }

    private void createIonSpinnerControl(Composite parent, String strIon) {
        Label lbl = new Label(parent, 0);
        lbl.setText("# " + strIon + " ions");
        Spinner spn = this.getDefaultSpinner(parent);
        this.m_mapIonToSpinner.put(strIon, spn);
        if (strIon.equals("H")) {
            return;
        }
        lbl = new Label(parent, 0);
        lbl.setText("ex. " + strIon + " ions");
        spn = this.getDefaultSpinner(parent);
        this.m_mapExIonToSpinner.put(strIon, spn);
    }

    private void setParameters(MassOptions massOptions) {
        int value;
        Spinner spnIon;
        Spinner spn;
        this.m_cmbIsotope.setItems(new String[]{"MONO", "AVG"});
        this.m_cmbDeriv.setItems(new String[]{"Und", "perMe", "perDMe", "perAc", "perDAc"});
        ArrayList<String> lRedends = new ArrayList<String>();
        lRedends.addAll(ResidueDictionary.getReducingEndsString());
        lRedends.add("Other...");
        this.m_cmbRedend.setItems(lRedends.toArray(new String[0]));
        for (String strIon : this.m_mapIonToSpinner.keySet()) {
            spn = this.m_mapIonToSpinner.get(strIon);
            spn.setMinimum(0);
            spn.setMaximum(10);
            spn.setSelection(0);
        }
        for (String strExIon : this.m_mapExIonToSpinner.keySet()) {
            spn = this.m_mapExIonToSpinner.get(strExIon);
            spn.setMinimum(0);
            spn.setMaximum(50);
            spn.setSelection(0);
        }
        this.m_cmbIsotope.setText(massOptions.ISOTOPE);
        this.m_cmbDeriv.setText(massOptions.DERIVATIZATION);
        if (massOptions.REDUCING_END_TYPE == null) {
            this.m_cmbRedend.select(0);
            this.m_txtRedendName.setText("");
            this.m_txtRedendMass.setText("0");
        } else if (massOptions.REDUCING_END_TYPE.isCustomType()) {
            this.m_cmbRedend.setText("Other...");
            this.m_txtRedendName.setEnabled(true);
            this.m_txtRedendName.setText(massOptions.REDUCING_END_TYPE.getResidueName());
            this.m_txtRedendMass.setEnabled(true);
            double mass = massOptions.REDUCING_END_TYPE.getResidueMassMain() - MassUtils.water.getMainMass();
            this.m_txtRedendMass.setText("" + mass);
        } else {
            this.m_cmbRedend.setText(massOptions.REDUCING_END_TYPE.getName());
            this.m_txtRedendName.setText("");
            this.m_txtRedendMass.setText("0");
        }
        this.m_btnNegativeMode.setSelection(massOptions.ION_CLOUD.isNegative());
        for (String strIon : this.m_mapIonToSpinner.keySet()) {
            spnIon = this.m_mapIonToSpinner.get(strIon);
            value = massOptions.ION_CLOUD.get(strIon);
            spnIon.setSelection(value);
        }
        for (String strExIon : this.m_mapExIonToSpinner.keySet()) {
            spnIon = this.m_mapExIonToSpinner.get(strExIon);
            value = massOptions.NEUTRAL_EXCHANGES.get(strExIon);
            spnIon.setSelection(value);
        }
    }

    private void save() {
        this.m_massOptions.ISOTOPE = this.m_cmbIsotope.getText();
        this.m_massOptions.DERIVATIZATION = this.m_cmbDeriv.getText();
        ResidueType resTypeRedend = this.m_cmbRedend.getText().equals("Other...") ? ResidueType.createOtherReducingEnd((String)this.m_txtRedendName.getText(), (double)Double.valueOf(this.m_txtRedendMass.getText())) : ResidueDictionary.findResidueType(this.m_cmbRedend.getText());
        this.m_massOptions.REDUCING_END_TYPE = resTypeRedend;
        int multiplier = this.m_btnNegativeMode.getSelection() ? -1 : 1;
        for (String strIon : this.m_mapIonToSpinner.keySet()) {
            int nIon = this.m_mapIonToSpinner.get(strIon).getSelection();
            if (!strIon.equals("Cl") && !strIon.equals("H2PO4")) {
                nIon *= multiplier;
            }
            this.m_massOptions.ION_CLOUD.set(strIon, nIon);
        }
        int nExchange = 0;
        for (String strIon : this.m_mapExIonToSpinner.keySet()) {
            int nIon = this.m_mapExIonToSpinner.get(strIon).getSelection();
            this.m_massOptions.NEUTRAL_EXCHANGES.set(strIon, nIon);
            nExchange += nIon;
        }
        this.m_massOptions.NEUTRAL_EXCHANGES.set("H", -nExchange);
    }

    private boolean validate() {
        this.setErrorMessage(null);
        if (!this.m_cmbRedend.getText().equals("Other...")) {
            return true;
        }
        Character[] symbols = new Character[]{Character.valueOf('#'), Character.valueOf('.'), Character.valueOf('_')};
        List<Character> lAllowedSymbols = Arrays.asList(symbols);
        String strRedend = this.m_txtRedendName.getText();
        int i = 0;
        while (i < strRedend.length()) {
            char c = strRedend.charAt(i);
            if (!(Character.isAlphabetic(c) || Character.isDigit(c) || lAllowedSymbols.contains(Character.valueOf(c)))) {
                this.setErrorMessage("The symbol \"" + c + "\" cannot be used for reducing end name.");
                return false;
            }
            ++i;
        }
        if (strRedend.length() > 20) {
            this.setErrorMessage("The reducing end name is too long.");
        }
        try {
            Double.valueOf(this.m_txtRedendMass.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage("The mass value specified for the reducing end is not valid.");
            return false;
        }
        return true;
    }

    protected void okPressed() {
        if (!this.validate()) {
            MessageBox box = new MessageBox(this.getShell(), 33);
            box.setMessage(this.getErrorMessage());
            return;
        }
        this.save();
        super.okPressed();
    }
}

