/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.structure.mass;

import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.MassUtils;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueType;

public class GlycanMassCalculator {
    private Glycan glycan;
    private MassOptions mass_options;

    public GlycanMassCalculator(Glycan glycan) {
        this.glycan = glycan;
        this.mass_options = glycan.getMassOptions();
    }

    public double computeMZ() {
        double mass = this.computeMass();
        return this.glycan.getMassOptions().ION_CLOUD.and(this.glycan.getMassOptions().NEUTRAL_EXCHANGES).computeMZ(mass);
    }

    public double computeMass() {
        if (!(!this.glycan.hasRepetition() || this.glycan.areAllRepetitionsConstant(this.glycan.getRoot()) && this.glycan.areAllRepetitionsConstant(this.glycan.getBracket()))) {
            return -1.0;
        }
        if (this.containsUnknownMass()) {
            return -1.0;
        }
        return this.computeMass(this.glycan.getRoot(), 1.0) + this.computeMass(this.glycan.getBracket(), 1.0);
    }

    private boolean containsUnknownMass() {
        return this.containsUnknownMass(this.glycan.getRoot()) || this.glycan.getBracket() != null && this.containsUnknownMass(this.glycan.getBracket());
    }

    private boolean containsUnknownMass(Residue node) {
        if (node == null || node.getTypeName().equals("Sugar")) {
            return true;
        }
        if (!node.isRepetition() && !node.isReducingEnd() && node.getType().getComposition().equals("?")) {
            return true;
        }
        for (Linkage l : node.getChildrenLinkages()) {
            if (!this.containsUnknownMass(l.getChildResidue())) continue;
            return true;
        }
        return false;
    }

    private double computeMass(Residue node, double multipler) {
        if (node == null || node.getTypeName().equals("Sugar")) {
            return 0.0;
        }
        if (node.isStartRepetition()) {
            Residue end = node.getEndRepitionResidue();
            if (end.getMaxRepetitions() == end.getMinRepetitions()) {
                multipler = end.getMaxRepetitions();
            }
        } else if (node.isEndRepetition()) {
            multipler = 1.0;
        }
        ResidueType type = node.getType();
        int no_bonds = node.getNoBonds();
        double mass = 0.0;
        if (!node.isRepetition() || this.checkCompositionResidue(node)) {
            mass = type.getMass();
        }
        if (node.isReducingEnd() && node.getType().makesAlditol()) {
            mass += 2.0 * MassUtils.hydrogen.getMass();
        }
        if (node.isBracket() && !this.glycan.isComposition()) {
            int no_linked_labiles = Math.min(this.glycan.countLabilePositions(), this.glycan.countDetachedLabiles());
            mass -= (double)(no_bonds - no_linked_labiles) * this.substitutionMass();
        } else if (node.isCleavage() && !node.isRingFragment()) {
            if (node.isReducingEnd() && !node.hasChildren()) {
                mass += this.substitutionMass();
            }
        } else if (!node.isRepetition()) {
            mass = this.isDropped(type) ? (mass -= type.getMass() - MassUtils.water.getMass() - this.substitutionMass()) : (mass += (double)(this.noSubstitutions(type) - no_bonds) * this.substitutionMass());
        }
        mass *= multipler;
        if (node.getParent() != null && node.getParent().isStartRepetition()) {
            Residue startRepResidue = node.getParent();
            int noBonds = startRepResidue.getLinkageAt(0).getNoBonds();
            int repetitions = startRepResidue.getEndRepitionResidue().getMaxRepetitions();
            mass += (double)((repetitions - 1) * (noBonds - 1)) * MassUtils.water.getMass();
            mass += (double)((repetitions - 2) * (noBonds - 1)) * this.substitutionMass();
        }
        for (Linkage l : node.getChildrenLinkages()) {
            if (l.getChildResidue().isRepetition() && l.getChildResidue().isEndRepetition()) {
                mass += (double)(no_bonds - (l.getChildResidue().getNoBonds() + no_bonds - 2)) * this.substitutionMass();
            }
            mass -= MassUtils.water.getMass() * (double)l.getNoBonds() * multipler;
            mass += this.computeMass(l.getChildResidue(), multipler);
        }
        return mass;
    }

    private boolean checkCompositionResidue(Residue node) {
        if (this.glycan.isComposition()) {
            return !node.isBracket();
        }
        return false;
    }

    private double substitutionMass() {
        if (this.mass_options.DERIVATIZATION.equals("perMe")) {
            return MassUtils.methyl.getMass() - MassUtils.hydrogen.getMass();
        }
        if (this.mass_options.DERIVATIZATION.equals("perDMe")) {
            return MassUtils.dmethyl.getMass() - MassUtils.hydrogen.getMass();
        }
        if (this.mass_options.DERIVATIZATION.equals("perAc")) {
            return MassUtils.acetyl.getMass() - MassUtils.hydrogen.getMass();
        }
        if (this.mass_options.DERIVATIZATION.equals("perDAc")) {
            return MassUtils.dacetyl.getMass() - MassUtils.hydrogen.getMass();
        }
        if (this.mass_options.DERIVATIZATION.equals("perMe(C^13)")) {
            return MassUtils.heavyMethyl.getMass() - MassUtils.hydrogen.getMass();
        }
        return 0.0;
    }

    private boolean isDropped(ResidueType type) {
        if (type.isDroppedWithMethylation() && (this.mass_options.DERIVATIZATION.equals("perMe") || this.mass_options.DERIVATIZATION.equals("perDMe") || this.mass_options.DERIVATIZATION.equals("perMe(C^13)"))) {
            return true;
        }
        return type.isDroppedWithAcetylation() && (this.mass_options.DERIVATIZATION.equals("perAc") || this.mass_options.DERIVATIZATION.equals("perAc"));
    }

    private int noSubstitutions(ResidueType type) {
        if (this.mass_options.DERIVATIZATION.equals("perMe") || this.mass_options.DERIVATIZATION.equals("perDMe") || this.mass_options.DERIVATIZATION.equals("perMe(C^13)")) {
            return type.getNoMethyls();
        }
        if (this.mass_options.DERIVATIZATION.equals("perAc") || this.mass_options.DERIVATIZATION.equals("perDAc")) {
            return type.getNoAcetyls();
        }
        return 0;
    }
}

