/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class ResidueDictionary {
    private static HashMap<String, ResidueType> dictionary = new HashMap();
    private static List<String> superclasses = new LinkedList<String>();
    private static TreeMap<Integer, ResidueType> direct_residues = new TreeMap();
    private static List<ResidueType> other_residues = new LinkedList<ResidueType>();
    private static List<ResidueType> all_residues = new LinkedList<ResidueType>();
    private static HashMap<String, List<ResidueType>> all_residues_map = new HashMap();

    static {
        ResidueDictionary.initDictionary();
    }

    public static ResidueType getResidueType(String type_name) throws Exception {
        ResidueType ret = ResidueDictionary.findResidueType(type_name);
        if (ret == null) {
            throw new Exception("Invalid type: <" + type_name + ">");
        }
        return ret;
    }

    public static boolean hasResidueType(String type_name) {
        return ResidueDictionary.findResidueType(type_name) != null;
    }

    public static ResidueType findResidueType(String type_name) {
        ResidueType ret = dictionary.get(type_name.toLowerCase());
        if (ret != null) {
            return ret;
        }
        if (type_name.indexOf(61) != -1) {
            String[] tokens = type_name.split("=");
            String name = tokens[0];
            double mass = Double.valueOf(tokens[1].substring(0, tokens[1].length() - 1));
            return ResidueType.createOtherReducingEnd((String)name, (double)mass);
        }
        return null;
    }

    public static Iterator<ResidueType> iterator() {
        return all_residues.iterator();
    }

    public static Collection<ResidueType> directResidues() {
        return direct_residues.values();
    }

    public static Collection<ResidueType> otherResidues() {
        return other_residues;
    }

    public static Collection<ResidueType> allResidues() {
        return all_residues;
    }

    public static Collection<String> getSuperclasses() {
        return superclasses;
    }

    public static Collection<ResidueType> getResidues(String superclass) {
        return all_residues_map.get(superclass);
    }

    public static Collection<ResidueType> getReducingEnds() {
        LinkedList<ResidueType> ret = new LinkedList<ResidueType>();
        for (ResidueType rt : all_residues) {
            if (!rt.canBeReducingEnd()) continue;
            ret.add(rt);
        }
        return ret;
    }

    public static Collection<String> getReducingEndsString() {
        LinkedList<String> ret = new LinkedList<String>();
        for (ResidueType rt : all_residues) {
            if (!rt.canBeReducingEnd()) continue;
            ret.add(rt.getName());
        }
        return ret;
    }

    public static Residue newResidue(String type_name) throws Exception {
        return new Residue(ResidueDictionary.getResidueType(type_name));
    }

    public static Residue createReducingEnd() {
        return new Residue(ResidueDictionary.findResidueType("freeEnd"));
    }

    public static Residue createStartRepetition() {
        return new Residue(ResidueDictionary.findResidueType("#startrep"));
    }

    public static Residue createEndRepetition() {
        return new Residue(ResidueDictionary.findResidueType("#endrep_?_?"));
    }

    public static Residue createEndRepetition(String min, String max) {
        return new Residue(ResidueType.createEndRepetition((String)min, (String)max));
    }

    public static Residue createBracket() {
        return new Residue(ResidueDictionary.findResidueType("#bracket"));
    }

    public static Residue createAttachPoint() {
        return new Residue(ResidueDictionary.findResidueType("#attach"));
    }

    public static Residue createBCleavage() {
        return new Residue(ResidueDictionary.findResidueType("#bcleavage"));
    }

    public static Residue createCCleavage() {
        return new Residue(ResidueDictionary.findResidueType("#ccleavage"));
    }

    public static Residue createYCleavage() {
        return new Residue(ResidueDictionary.findResidueType("#ycleavage"));
    }

    public static Residue createZCleavage() {
        return new Residue(ResidueDictionary.findResidueType("#zcleavage"));
    }

    public static Residue createLCleavage() {
        return new Residue(ResidueDictionary.findResidueType("#lcleavage"));
    }

    private ResidueDictionary() {
    }

    public static void loadDictionary(String filename) {
        ResidueDictionary.initDictionary();
        superclasses.clear();
        direct_residues.clear();
        other_residues.clear();
        all_residues.clear();
        all_residues_map.clear();
        try {
            String line;
            URL file_url = ResidueDictionary.class.getResource(filename);
            if (file_url == null) {
                throw new FileNotFoundException(filename);
            }
            BufferedReader is = new BufferedReader(new InputStreamReader(file_url.openStream()));
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim((String)line)).length() <= 0 || line.startsWith("%")) continue;
                ResidueDictionary.add(new ResidueType(line));
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            dictionary.clear();
        }
    }

    private static void add(ResidueType type) {
        dictionary.put(type.getName().toLowerCase(), type);
        String[] stringArray = type.getSynonyms();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            dictionary.put(s.toLowerCase(), type);
            ++n2;
        }
        String superclass = type.getSuperclass();
        if (all_residues_map.get(superclass) == null) {
            superclasses.add(superclass);
            all_residues_map.put(superclass, new LinkedList());
        }
        if (type.getToolbarOrder() != 0) {
            direct_residues.put(type.getToolbarOrder(), type);
        } else {
            other_residues.add(type);
        }
        all_residues.add(type);
        all_residues_map.get(superclass).add(type);
    }

    private static void initDictionary() {
        dictionary.clear();
        ResidueDictionary.add(new ResidueType());
        ResidueDictionary.add(ResidueType.createAttachPoint());
        ResidueDictionary.add(ResidueType.createBracket());
        ResidueDictionary.add(ResidueType.createStartRepetition());
        ResidueDictionary.add(ResidueType.createEndRepetition());
        ResidueDictionary.add(ResidueType.createBCleavage());
        ResidueDictionary.add(ResidueType.createCCleavage());
        ResidueDictionary.add(ResidueType.createYCleavage());
        ResidueDictionary.add(ResidueType.createZCleavage());
        ResidueDictionary.add(ResidueType.createLCleavage());
        if (dictionary.get("freeEnd") == null) {
            ResidueDictionary.add(ResidueType.createFreeReducingEnd());
        }
    }
}

