/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.grits.toolbox.tools.glycanbuilder.core.structure.type.CrossRingFragmentType;

public class CrossRingFragmentDictionary {
    private static Vector<CrossRingFragmentType> dictionary = new Vector();

    private CrossRingFragmentDictionary() {
    }

    public static void loadDictionary(String filename) {
        dictionary.clear();
        try {
            String line;
            URL file_url = CrossRingFragmentDictionary.class.getResource(filename);
            if (file_url == null) {
                throw new FileNotFoundException(filename);
            }
            BufferedReader is = new BufferedReader(new InputStreamReader(file_url.openStream()));
            while ((line = is.readLine()) != null) {
                if ((line = TextUtils.trim((String)line)).length() <= 0 || line.startsWith("%")) continue;
                CrossRingFragmentType toadd = new CrossRingFragmentType(line);
                dictionary.add(toadd);
            }
            is.close();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            dictionary.clear();
        }
    }

    public static Collection<CrossRingFragmentType> getCrossRingFragmentTypes(Residue r) {
        Vector<CrossRingFragmentType> ret = new Vector<CrossRingFragmentType>();
        for (CrossRingFragmentType crt : dictionary) {
            if (!crt.matches(r)) continue;
            ret.add(crt);
        }
        return ret;
    }

    public static Collection<CrossRingFragmentType> getCrossRingFragmentTypesA(Residue r) {
        Vector<CrossRingFragmentType> ret = new Vector<CrossRingFragmentType>();
        for (CrossRingFragmentType crt : dictionary) {
            if (!crt.matches(r) || !crt.isACleavage()) continue;
            ret.add(crt);
        }
        return ret;
    }

    public static Collection<CrossRingFragmentType> getCrossRingFragmentTypesX(Residue r) {
        Vector<CrossRingFragmentType> ret = new Vector<CrossRingFragmentType>();
        for (CrossRingFragmentType crt : dictionary) {
            if (!crt.matches(r) || !crt.isXCleavage()) continue;
            ret.add(crt);
        }
        return ret;
    }

    public static CrossRingFragmentType getCrossRingFragmentType(char fragment_type, int first_pos, int last_pos, Residue r) {
        for (CrossRingFragmentType crt : dictionary) {
            if (!crt.matches(fragment_type, first_pos, last_pos, r)) continue;
            return crt;
        }
        return null;
    }

    public static Residue newCrossRingFragment(char fragment_type, int first_pos, int last_pos, Residue r) throws Exception {
        if (r == null) {
            throw new Exception("Cannot create a cross ring fragment without a residue");
        }
        CrossRingFragmentType type = CrossRingFragmentDictionary.getCrossRingFragmentType(fragment_type, first_pos, last_pos, r);
        if (type == null) {
            throw new Exception("Invalid " + fragment_type + " cross-ring cleavage at positions " + first_pos + "," + last_pos + " of residue " + r.getTypeName());
        }
        Residue ret = new Residue((ResidueType)type);
        ret.setCleavedResidue(r);
        return ret;
    }

    public static Residue newFragment(String type_name, Residue cleaved) {
        int last_pos;
        int first_pos;
        if (type_name == null || cleaved == null) {
            return null;
        }
        if (!type_name.startsWith("#acleavage") && !type_name.startsWith("#xcleavage")) {
            return null;
        }
        Vector tokens = TextUtils.tokenize((String)type_name, (String)"_");
        char fragment_type = type_name.charAt(1);
        CrossRingFragmentType crt = CrossRingFragmentDictionary.getCrossRingFragmentType(fragment_type, first_pos = Integer.parseInt((String)tokens.elementAt(1)), last_pos = Integer.parseInt((String)tokens.elementAt(2)), cleaved);
        return crt != null ? new Residue((ResidueType)crt) : null;
    }
}

