/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.renderer.utils;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;

public class TextShapeUtils {
    private static double dCurrentDPIScale = 1.0;

    static {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                dCurrentDPIScale = display.getDPI().x / 72;
                if (dCurrentDPIScale < 1.0) {
                    dCurrentDPIScale = 1.0;
                }
            }
        });
    }

    public static Rectangle textBounds(Device device, String text, String font_face, int font_size) {
        if (text.length() == 0) {
            return new Rectangle(0, 0, 0, font_size);
        }
        Font font = new Font(device, font_face, font_size, 0);
        Rectangle ret = TextShapeUtils.textBounds(font, text);
        font.dispose();
        return ret;
    }

    public static Rectangle textBounds(Font font, String text) {
        TextLayout tl = new TextLayout(font.getDevice());
        tl.setText(text);
        tl.setFont(font);
        Rectangle ret = tl.getBounds();
        tl.dispose();
        return ret;
    }

    public static Path getTextPath(Device device, String text, String font_face, int font_size) {
        return TextShapeUtils.getTextPath(device, 0.0, 0.0, text, font_face, font_size);
    }

    public static Path getTextPath(Device device, double x, double y, String text, String font_face, int font_size) {
        Font font = new Font(device, font_face, font_size, 0);
        Path p = new Path(device);
        p.addString(text, (float)x, (float)y, font);
        font.dispose();
        return p;
    }

    public static double scaleWithDPI(double size) {
        return size * dCurrentDPIScale;
    }

    public static double getFontSizePixel(int fontSize) {
        double size = (double)fontSize / 0.75;
        return TextShapeUtils.scaleWithDPI(size);
    }
}

