/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.renderer.utils;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class Geometry {
    public static Rectangle makeRectangle(Point a, Point b) {
        if (a != null && b != null) {
            int x = a.x < b.x ? a.x : b.x;
            int y = a.y < b.y ? a.y : b.y;
            int w = Math.abs(a.x - b.x);
            int h = Math.abs(a.y - b.y);
            return new Rectangle(x, y, w, h);
        }
        return null;
    }

    public static Point center(Rectangle r) {
        return new Point(Geometry.midx(r), Geometry.midy(r));
    }

    public static int midx(Rectangle r) {
        return r.x + r.width / 2;
    }

    public static int midy(Rectangle r) {
        return r.y + r.height / 2;
    }

    public static int left(Rectangle r) {
        return r.x;
    }

    public static int top(Rectangle r) {
        return r.y;
    }

    public static int right(Rectangle r) {
        return r.x + r.width;
    }

    public static int bottom(Rectangle r) {
        return r.y + r.height;
    }

    public static int width(Rectangle r) {
        return r.width;
    }

    public static int height(Rectangle r) {
        return r.height;
    }

    public static Point topleft(Rectangle r) {
        return new Point(Geometry.left(r), Geometry.top(r));
    }

    public static Point topright(Rectangle r) {
        return new Point(Geometry.right(r), Geometry.top(r));
    }

    public static Point bottomleft(Rectangle r) {
        return new Point(Geometry.left(r), Geometry.bottom(r));
    }

    public static Point bottomright(Rectangle r) {
        return new Point(Geometry.right(r), Geometry.bottom(r));
    }

    public static Rectangle union(Rectangle a, Rectangle b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.union(b);
    }

    public static Rectangle expand(Rectangle r, int d) {
        return new Rectangle(r.x - d, r.y - d, r.width + 2 * d, r.height + 2 * d);
    }

    public static double distance(Rectangle a, Rectangle b) {
        return Geometry.distance(Geometry.center(a), Geometry.center(b));
    }

    public static double distance(Point a, Rectangle b) {
        return Geometry.distance(a, Geometry.center(b));
    }

    public static double distance(Point a, Point b) {
        return Math.sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
    }

    public static double distance(Point p, Point s1, Point s2) {
        double u = (double)((p.x - s1.x) * (s2.x - s1.x) + (p.y - s1.y) * (s2.y - s1.y)) / (double)((s2.x - s1.x) * (s2.x - s1.x) + (s2.y - s1.y) * (s2.y - s1.y));
        if (u < 0.0) {
            return Geometry.distance(p, s1);
        }
        if (u > 1.0) {
            return Geometry.distance(p, s2);
        }
        return Geometry.distance(p, new Point((int)((double)s1.x + u * (double)(s2.x - s1.x)), (int)((double)s1.y + u * (double)(s2.y - s1.y))));
    }

    public static double angle(Point p1, Point p2) {
        if (p1.equals((Object)p2)) {
            return -1.5707963267948966;
        }
        double x1 = p1.x;
        double x2 = p2.x;
        double y1 = p1.y;
        double y2 = p2.y;
        double d = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        double a = Math.acos((x1 - x2) / d);
        return y1 >= y2 ? a : -a;
    }

    public static double normalize(double angle) {
        while (angle <= -Math.PI) {
            angle += Math.PI * 2;
        }
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        return angle;
    }

    public static boolean isDown(double angle) {
        return (angle = Geometry.normalize(angle)) >= -2.356194490192345 && angle < -0.7853981633974483;
    }

    public static boolean isRight(double angle) {
        return (angle = Geometry.normalize(angle)) >= -0.7853981633974483 && angle < 0.7853981633974483;
    }

    public static boolean isUp(double angle) {
        return (angle = Geometry.normalize(angle)) >= 0.7853981633974483 && angle < 2.356194490192345;
    }

    public static boolean isLeft(double angle) {
        return (angle = Geometry.normalize(angle)) >= 2.356194490192345 || angle < -2.356194490192345;
    }

    public static boolean isUp(Rectangle f, Rectangle t) {
        int d_x = Geometry.midx(f) - Geometry.midx(t);
        int d_y = Geometry.midy(f) - Geometry.midy(t);
        return d_y < 0 && Math.abs(d_y) > Math.abs(d_x);
    }

    public static boolean isDown(Rectangle f, Rectangle t) {
        int d_x = Geometry.midx(f) - Geometry.midx(t);
        int d_y = Geometry.midy(f) - Geometry.midy(t);
        return d_y > 0 && Math.abs(d_y) > Math.abs(d_x);
    }

    public static boolean isLeft(Rectangle f, Rectangle t) {
        int d_x = Geometry.midx(f) - Geometry.midx(t);
        int d_y = Geometry.midy(f) - Geometry.midy(t);
        return d_x < 0 && Math.abs(d_x) > Math.abs(d_y);
    }

    public static boolean isRight(Rectangle f, Rectangle t) {
        int d_x = Geometry.midx(f) - Geometry.midx(t);
        int d_y = Geometry.midy(f) - Geometry.midy(t);
        return d_x > 0 && Math.abs(d_x) > Math.abs(d_y);
    }

    public static double getExclusionRadius(Point center, double angle, Rectangle bbox) {
        if (!bbox.contains(center)) {
            return 0.0;
        }
        double tla = Geometry.angle(Geometry.topleft(bbox), center);
        double tra = Geometry.angle(Geometry.topright(bbox), center);
        double bla = Geometry.angle(Geometry.bottomleft(bbox), center);
        double bra = Geometry.angle(Geometry.bottomright(bbox), center);
        double R = 0.0;
        R = angle >= tra && angle <= bra ? (double)(Geometry.right(bbox) - center.x) / Math.cos(angle) : (angle >= bra && angle <= bla ? (double)(Geometry.bottom(bbox) - center.y) / Math.cos(angle - 1.5707963267948966) : (angle >= tla && angle <= tra ? (double)(center.y - Geometry.top(bbox)) / Math.cos(angle + 1.5707963267948966) : (double)(center.x - Geometry.left(bbox)) / Math.cos(angle + Math.PI)));
        return R;
    }

    public static boolean overlapx(Rectangle a, Rectangle b, int toll) {
        if (a == null || b == null) {
            return false;
        }
        int la = Geometry.left(a) - toll;
        int ra = Geometry.right(a) + toll;
        int lb = Geometry.left(b) - toll;
        int rb = Geometry.right(b) + toll;
        return la <= lb && lb <= ra || la <= rb && rb <= ra || lb <= la && la <= rb || lb <= ra && ra <= rb;
    }

    public static boolean overlapy(Rectangle a, Rectangle b, int toll) {
        if (a == null || b == null) {
            return false;
        }
        int ta = Geometry.top(a) - toll;
        int ba = Geometry.bottom(a) + toll;
        int tb = Geometry.top(b) - toll;
        int bb = Geometry.bottom(b) + toll;
        return ta <= tb && tb <= ba || ta <= bb && bb <= ba || tb <= ta && ta <= bb || tb <= ba && ba <= bb;
    }

    public static Point translate(Point p, double dx, double dy) {
        return new Point((int)((double)p.x + dx), (int)((double)p.y + dy));
    }
}

