/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.renderer;

import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Transform;
import org.eurocarbdb.application.glycanbuilder.ResAngle;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueStyle;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.grits.toolbox.tools.glycanbuilder.core.config.GraphicOptionsSWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.GlycanRendererSWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.SWTRenderer;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.style.ResidueStyleDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.utils.Geometry;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.utils.TextShapeUtils;

public class ResidueRendererSWT
extends SWTRenderer {
    protected ResidueStyleDictionary theResidueStyleDictionary;
    protected GraphicOptionsSWT theGraphicOptions;

    public ResidueRendererSWT(Device device) {
        super(device);
        this.theResidueStyleDictionary = new ResidueStyleDictionary();
        this.theGraphicOptions = new GraphicOptionsSWT();
    }

    public ResidueRendererSWT(Device device, GlycanRendererSWT src) {
        super(device);
        this.theResidueStyleDictionary = src.getResidueStyleDictionary();
        this.theGraphicOptions = src.getGraphicOptions();
    }

    public GraphicOptionsSWT getGraphicOptions() {
        return this.theGraphicOptions;
    }

    public void setGraphicOptions(GraphicOptionsSWT opt) {
        this.theGraphicOptions = opt;
    }

    public ResidueStyleDictionary getResidueStyleDictionary() {
        return this.theResidueStyleDictionary;
    }

    public void setResidueStyleDictionary(ResidueStyleDictionary residueStyleDictionary) {
        this.theResidueStyleDictionary = residueStyleDictionary;
    }

    public Image getImage(ResidueType type, int max_y_size) {
        int orientation = this.theGraphicOptions.ORIENTATION;
        this.theGraphicOptions.ORIENTATION = 0;
        Residue node = new Residue(type);
        Rectangle bbox = this.computeBoundingBox(node, false, 4, 4, new ResAngle(), max_y_size - 8, max_y_size - 8);
        Image img = new Image(this.m_device, bbox.width + 8, bbox.height + 8);
        GC gc = new GC((Drawable)img);
        gc.setAntialias(1);
        gc.setBackground(this.getBackgroundColor());
        gc.fillRectangle(0, 0, bbox.width + 8, bbox.height + 8);
        this.paint(gc, node, false, false, null, bbox, null, new ResAngle());
        gc.dispose();
        this.theGraphicOptions.ORIENTATION = orientation;
        return img;
    }

    public String getText(Residue node) {
        if (node == null) {
            return "";
        }
        ResidueType type = node.getType();
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        String text = style.getText();
        return text != null ? text : type.getResidueName();
    }

    public String getText(Residue node, boolean on_border) {
        if (node == null) {
            return "";
        }
        if (on_border && node.isSpecial() && !node.isLCleavage()) {
            return "*";
        }
        String text = null;
        text = on_border && node.isLCleavage() ? this.getText(node.getCleavedResidue()) : this.getText(node);
        if (on_border && !node.getParentLinkage().hasUncertainParentPositions() && this.theGraphicOptions.SHOW_INFO) {
            text = String.valueOf(node.getParentLinkage().getParentPositionsString()) + text;
        }
        if (on_border && node.isLCleavage()) {
            text = "(" + text + ")";
        }
        return text;
    }

    protected Rectangle computeBoundingBox(Residue node, boolean on_border, int x, int y, ResAngle orientation, int node_size, int max_y_size) {
        Rectangle dim;
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        String shape = style.getShape();
        if (max_y_size < node_size) {
            node_size = max_y_size;
        }
        if (shape == null || on_border) {
            String text = this.getText(node, on_border);
            int font_size = this.theGraphicOptions.NODE_FONT_SIZE;
            int x_size = TextShapeUtils.textBounds((Device)this.m_device, (String)text, (String)this.theGraphicOptions.NODE_FONT_FACE, (int)font_size).width;
            dim = x_size > node_size ? new Rectangle(0, 0, x_size, node_size) : new Rectangle(0, 0, node_size, node_size);
            orientation = this.theGraphicOptions.getOrientationAngle();
        } else if (shape.equals("startrep") || shape.equals("endrep")) {
            int size = Math.min(node_size * 2, max_y_size);
            double linkInfoSize = TextShapeUtils.getFontSizePixel(this.theGraphicOptions.LINKAGE_INFO_SIZE);
            int font_size = (int)Math.round(linkInfoSize) + 1;
            dim = new Rectangle(0, 0, size / 2, size + 2 * font_size);
        } else {
            dim = shape.equals("point") ? new Rectangle(0, 0, 1, 1) : new Rectangle(0, 0, node_size, node_size);
        }
        if (orientation.equals(0) || orientation.equals(180)) {
            return new Rectangle(x, y, dim.width, dim.height);
        }
        return new Rectangle(x, y, dim.height, dim.width);
    }

    private static int sat(int v, int t) {
        if (v > t) {
            return t;
        }
        return v;
    }

    private static int sig(int v) {
        return 128 + v / 2;
    }

    public void paint(GC gc, Residue node, boolean selected, boolean on_border, Rectangle par_bbox, Rectangle cur_bbox, Rectangle sup_bbox, ResAngle orientation) {
        this.paint(gc, node, selected, true, on_border, par_bbox, cur_bbox, sup_bbox, orientation);
    }

    public void paint(GC gc, Residue node, boolean selected, boolean active, boolean on_border, Rectangle par_bbox, Rectangle cur_bbox, Rectangle sup_bbox, ResAngle orientation) {
        if (node == null) {
            return;
        }
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        Path shape = this.createShape(gc.getDevice(), node, par_bbox, cur_bbox, sup_bbox, orientation);
        Path text_shape = this.createTextShape(gc.getDevice(), node, par_bbox, cur_bbox, sup_bbox, orientation);
        Path fill_shape = this.createFillShape(gc.getDevice(), node, cur_bbox);
        RGB shape_rgb = new RGB(style.getShapeColor().getRed(), style.getShapeColor().getGreen(), style.getShapeColor().getBlue());
        RGB fill_rgb = new RGB(style.getFillColor().getRed(), style.getFillColor().getGreen(), style.getFillColor().getBlue());
        RGB text_rgb = new RGB(style.getTextColor().getRed(), style.getTextColor().getGreen(), style.getTextColor().getBlue());
        if (selected) {
            fill_rgb = new RGB(ResidueRendererSWT.sig(fill_rgb.red), ResidueRendererSWT.sig(fill_rgb.green), ResidueRendererSWT.sig(fill_rgb.blue));
        }
        if (!active) {
            shape_rgb = new RGB(ResidueRendererSWT.sig(shape_rgb.red), ResidueRendererSWT.sig(shape_rgb.green), ResidueRendererSWT.sig(shape_rgb.blue));
            fill_rgb = new RGB(ResidueRendererSWT.sig(fill_rgb.red), ResidueRendererSWT.sig(fill_rgb.green), ResidueRendererSWT.sig(fill_rgb.blue));
            text_rgb = new RGB(ResidueRendererSWT.sig(text_rgb.red), ResidueRendererSWT.sig(text_rgb.green), ResidueRendererSWT.sig(text_rgb.blue));
        }
        Color shape_color = new Color(gc.getDevice(), shape_rgb);
        Color fill_color = new Color(gc.getDevice(), fill_rgb);
        Color text_color = new Color(gc.getDevice(), text_rgb);
        if (shape != null && !on_border) {
            if (fill_shape != null) {
                Transform tr = new Transform(gc.getDevice());
                tr.translate(1.0f, 1.0f);
                gc.setTransform(tr);
                Region old_clip = new Region();
                gc.getClipping(old_clip);
                gc.setClipping(shape);
                gc.setBackground(style.isFillNegative() ? fill_color : this.getColorWhite());
                gc.fillPath(shape);
                gc.setBackground(style.isFillNegative() ? this.getColorWhite() : fill_color);
                gc.fillPath(fill_shape);
                tr.translate(-1.0f, -1.0f);
                gc.setTransform(tr);
                gc.setForeground(shape_color);
                gc.drawPath(fill_shape);
                tr.translate(1.0f, 1.0f);
                gc.setTransform(tr);
                gc.setClipping(old_clip);
                old_clip.dispose();
                tr.translate(-1.0f, -1.0f);
                gc.setTransform(tr);
                tr.dispose();
            }
            gc.setLineAttributes(selected ? new LineAttributes(2.0f) : new LineAttributes(1.0f));
            gc.setForeground(shape_color);
            gc.drawPath(shape);
            gc.setLineAttributes(new LineAttributes(1.0f));
        } else if (selected) {
            gc.setLineAttributes(new LineAttributes(2.0f, 1, 2, 6, new float[]{5.0f, 5.0f}, 0.0f, 1.0f));
            gc.setForeground(shape_color);
            gc.drawRectangle(cur_bbox);
            gc.setLineAttributes(new LineAttributes(1.0f));
        }
        if (text_shape != null) {
            gc.setBackground(shape_color);
            gc.fillPath(text_shape);
        }
        if (shape == null || on_border || style.getText() != null) {
            if (shape == null || on_border) {
                orientation = this.theGraphicOptions.getOrientationAngle();
            } else if (style.getText() != null) {
                orientation = new ResAngle(0);
            }
            String text = this.getText(node, on_border);
            int font_size = this.theGraphicOptions.NODE_FONT_SIZE;
            int x_size = TextShapeUtils.textBounds((Device)gc.getDevice(), (String)text, (String)this.theGraphicOptions.NODE_FONT_FACE, (int)font_size).width;
            if (shape != null) {
                font_size = ResidueRendererSWT.sat(8 * font_size * cur_bbox.width / x_size / 10, font_size);
            }
            Font new_font = new Font(gc.getDevice(), this.theGraphicOptions.NODE_FONT_FACE, font_size, 0);
            Font old_font = gc.getFont();
            gc.setFont(new_font);
            Rectangle text_bound = TextShapeUtils.textBounds(new_font, text);
            int l = gc.getFontMetrics().getLeading();
            text_bound.height -= l * 2;
            gc.setForeground(text_color);
            if (orientation.equals(0) || orientation.equals(180)) {
                Rectangle text_rect = new Rectangle(Geometry.midx(cur_bbox) - text_bound.width / 2, Geometry.midy(cur_bbox) - text_bound.height / 2, text_bound.width, text_bound.height);
                if (shape == null || fill_shape == null) {
                    gc.setBackground(this.getBackgroundColor());
                    gc.fillRectangle(text_rect);
                }
                gc.drawText(text, text_rect.x, text_rect.y - l, true);
            } else {
                Rectangle text_rect = new Rectangle(Geometry.midx(cur_bbox) - text_bound.height / 2, Geometry.midy(cur_bbox) - text_bound.width / 2, text_bound.height, text_bound.width);
                if (shape == null || fill_shape == null) {
                    gc.setBackground(this.getBackgroundColor());
                    gc.fillRectangle(text_rect);
                }
                Transform transform = new Transform(gc.getDevice());
                transform.rotate(-90.0f);
                gc.setTransform(transform);
                gc.drawString(text, -(text_rect.y - l + text_rect.height), text_rect.x, true);
                transform.rotate(90.0f);
                gc.setTransform(transform);
                transform.dispose();
            }
            gc.setFont(old_font);
            new_font.dispose();
        }
        if (shape != null) {
            shape.dispose();
        }
        if (text_shape != null) {
            text_shape.dispose();
        }
        if (fill_shape != null) {
            fill_shape.dispose();
        }
        shape_color.dispose();
        fill_color.dispose();
        text_color.dispose();
    }

    private static Path createDiamond(Device device, float x, float y, float w, float h, boolean flat) {
        if (w % 2.0f == 1.0f) {
            w += 1.0f;
        }
        if (h % 2.0f == 1.0f) {
            h += 1.0f;
        }
        float h0 = h * (flat ? 0.8f : 1.0f);
        float y0 = y + (flat ? h * 0.1f : 0.0f);
        Path p = new Path(device);
        p.moveTo(x + w / 2.0f, y0);
        p.lineTo(x + w, y0 + h0 / 2.0f);
        p.lineTo(x + w / 2.0f, y0 + h0);
        p.lineTo(x, y0 + h0 / 2.0f);
        p.close();
        return p;
    }

    private static Path createDiamond(Device device, float x, float y, float w, float h) {
        return ResidueRendererSWT.createDiamond(device, x, y, w, h, false);
    }

    private static Path createFlatDiamond(Device device, float x, float y, float w, float h) {
        return ResidueRendererSWT.createDiamond(device, x, y, w, h, true);
    }

    private static Path createHatDiamond(Device device, float x, float y, float w, float h) {
        Path f = new Path(device);
        Path p1 = ResidueRendererSWT.createDiamond(device, x, y, w, h);
        f.addPath(p1);
        p1.dispose();
        Path p2 = new Path(device);
        p2.moveTo(x - 2.0f, y + h / 2.0f - 2.0f);
        p2.lineTo(x + w / 2.0f - 2.0f, y - 2.0f);
        f.addPath(p2);
        p2.dispose();
        return f;
    }

    private static Path createRHatDiamond(Device device, float x, float y, float w, float h) {
        Path f = new Path(device);
        Path p1 = ResidueRendererSWT.createDiamond(device, x, y, w, h);
        f.addPath(p1);
        p1.dispose();
        Path p2 = new Path(device);
        p2.moveTo(x + w + 2.0f, y + h / 2.0f - 2.0f);
        p2.lineTo(x + w / 2.0f + 2.0f, y - 2.0f);
        f.addPath(p2);
        p2.dispose();
        return f;
    }

    private static Path createRhombus(Device device, float x, float y, float w, float h) {
        Path p = new Path(device);
        p.moveTo(x + 0.5f * w, y);
        p.lineTo(x + 0.85f * w, y + 0.5f * h);
        p.lineTo(x + 0.5f * w, y + h);
        p.lineTo(x + 0.15f * w, y + 0.5f * h);
        p.close();
        return p;
    }

    private static Path createTriangle(Device device, double angle, float x, float y, float w, float h) {
        int iAngle = 0;
        iAngle = angle >= -0.7853981633974483 && angle <= 0.7853981633974483 ? 1 : (angle >= 0.7853981633974483 && angle <= 2.356194490192345 ? 2 : (angle >= -2.356194490192345 && angle <= -0.7853981633974483 ? 0 : 3));
        return ResidueRendererSWT.createTopTriangle(device, iAngle, x, y, w, h);
    }

    private static Path createTopTriangle(Device device, int angle, float x, float y, float w, float h) {
        Path p = new Path(device);
        if (angle == 0) {
            p.moveTo(x + w / 2.0f, y);
            p.lineTo(x + w, y + h);
            p.lineTo(x, y + h);
        }
        if (angle == 1) {
            p.moveTo(x + w, y + h / 2.0f);
            p.lineTo(x, y + h);
            p.lineTo(x, y);
        }
        if (angle == 2) {
            p.moveTo(x + w / 2.0f, y + h);
            p.lineTo(x, y);
            p.lineTo(x + w, y);
        }
        if (angle == 3) {
            p.moveTo(x, y + h / 2.0f);
            p.lineTo(x + w, y + h);
            p.lineTo(x + w, y);
        }
        p.close();
        return p;
    }

    private static Path createStar(Device device, double x, double y, double w, double h, int points) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double step = Math.PI / (double)points;
        double nstep = 1.5707963267948966 - 2.0 * step;
        double mrx = rx / (Math.cos(step) + Math.sin(step) / Math.tan(nstep));
        double mry = ry / (Math.cos(step) + Math.sin(step) / Math.tan(nstep));
        Path p = new Path(device);
        p.moveTo((float)((int)cx), (float)((int)y));
        int i = 1;
        while (i <= 2 * points) {
            if (i % 2 == 0) {
                p.lineTo((float)((int)(cx + rx * Math.cos((double)i * step - 1.5707963267948966))), (float)((int)(cy + ry * Math.sin((double)i * step - 1.5707963267948966))));
            } else {
                p.lineTo((float)((int)(cx + mrx * Math.cos((double)i * step - 1.5707963267948966))), (float)((int)(cy + mry * Math.sin((double)i * step - 1.5707963267948966))));
            }
            ++i;
        }
        p.close();
        return p;
    }

    private static Path createPolygon(Device device, double x, double y, double w, double h, int points, boolean flat) {
        double rx = w / 2.0;
        double ry = h / (flat ? 2.5 : 2.0);
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double step = Math.PI / ((double)points / 2.0);
        Path p = new Path(device);
        double rotate = 0.0;
        if (points % 2 == 1) {
            rotate = -1.5707963267948966;
            p.moveTo((float)cx, (float)y);
        } else {
            p.moveTo((float)(x + w), (float)cy);
        }
        int i = 1;
        while (i < points) {
            p.lineTo((float)(cx + rx * Math.cos((double)i * step + rotate)), (float)(cy + ry * Math.sin((double)i * step + rotate)));
            ++i;
        }
        p.close();
        return p;
    }

    private static Path createRegularPolygon(Device device, double x, double y, double w, double h, int points) {
        return ResidueRendererSWT.createPolygon(device, x, y, w, h, points, false);
    }

    private static Path createPentagon(Device device, double x, double y, double w, double h) {
        return ResidueRendererSWT.createRegularPolygon(device, x, y, w, h, 5);
    }

    private static Path createHexagon(Device device, double x, double y, double w, double h) {
        return ResidueRendererSWT.createRegularPolygon(device, x, y, w, h, 6);
    }

    private static Path createHeptagon(Device device, double x, double y, double w, double h) {
        return ResidueRendererSWT.createRegularPolygon(device, x, y, w, h, 7);
    }

    private static Path createFlatHexagon(Device device, double x, double y, double w, double h) {
        return ResidueRendererSWT.createPolygon(device, x, y, w, h, 6, true);
    }

    private static Path createCleavage(Device device, double angle, double x, double y, double w, double h, boolean has_oxygen) {
        Path f = new Path(device);
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double x1 = cx + rx * Math.cos(angle + 1.5707963267948966);
        double y1 = cy + ry * Math.sin(angle + 1.5707963267948966);
        double x2 = cx + rx * Math.cos(angle - 1.5707963267948966);
        double y2 = cy + ry * Math.sin(angle - 1.5707963267948966);
        double x3 = x2 + rx * Math.cos(angle);
        double y3 = y2 + ry * Math.sin(angle);
        Path p = new Path(device);
        p.moveTo((float)((int)x1), (float)((int)y1));
        p.lineTo((float)((int)x2), (float)((int)y2));
        p.lineTo((float)((int)x3), (float)((int)y3));
        p.lineTo((float)((int)x2), (float)((int)y2));
        f.addPath(p);
        p.dispose();
        if (has_oxygen) {
            double ox = cx + rx * Math.cos(angle);
            double oy = cy + ry * Math.sin(angle);
            Path o = new Path(device);
            o.addArc((float)((int)(ox - rx / 3.0)), (float)((int)(oy - ry / 3.0)), (float)((int)(rx / 1.5)), (float)((int)(ry / 1.5)), 0.0f, 360.0f);
            o.close();
            f.addPath(o);
            o.dispose();
        }
        return f;
    }

    private static Path createCrossRingCleavage(Device device, double angle, double x, double y, double w, double h, int first_pos, int last_pos) {
        Path c = new Path(device);
        Path p = ResidueRendererSWT.createHexagon(device, x + 1.0, y + 1.0, w - 2.0, h - 2.0);
        c.addPath(p);
        p.dispose();
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        Path p1 = new Path(device);
        p1.moveTo((float)cx, (float)cy);
        p1.lineTo((float)(cx + 1.2 * rx * Math.cos(angle + (double)first_pos * Math.PI / 3.0 - 0.5235987755982988)), (float)(cy + 1.2 * ry * Math.sin(angle + (double)first_pos * Math.PI / 3.0 - 0.5235987755982988)));
        c.addPath(p1);
        p1.dispose();
        Path p2 = new Path(device);
        p2.moveTo((float)cx, (float)cy);
        p2.lineTo((float)(cx + 1.2 * rx * Math.cos(angle + (double)last_pos * Math.PI / 3.0 - 0.5235987755982988)), (float)(cy + 1.2 * ry * Math.sin(angle + (double)last_pos * Math.PI / 3.0 - 0.5235987755982988)));
        c.addPath(p2);
        p2.dispose();
        return c;
    }

    private static Path createEnd(Device device, double angle, double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double x1 = cx + rx * Math.cos(angle - 1.5707963267948966);
        double y1 = cy + ry * Math.sin(angle - 1.5707963267948966);
        double x2 = cx + rx * Math.cos(angle + 1.5707963267948966);
        double y2 = cy + ry * Math.sin(angle + 1.5707963267948966);
        double curve = 0.75;
        double cx1 = cx + curve * rx * Math.cos(angle - 1.5707963267948966);
        double cy1 = cy + curve * ry * Math.sin(angle - 1.5707963267948966);
        double tx1 = cx1 + curve * rx * Math.cos(angle - Math.PI);
        double ty1 = cy1 + curve * ry * Math.sin(angle - Math.PI);
        double cx2 = cx + curve * rx * Math.cos(angle + 1.5707963267948966);
        double cy2 = cy + curve * ry * Math.sin(angle + 1.5707963267948966);
        double tx2 = cx2 + curve * rx * Math.cos(angle);
        double ty2 = cy2 + curve * ry * Math.sin(angle);
        Path p = new Path(device);
        p.moveTo((float)x1, (float)y1);
        p.cubicTo((float)tx1, (float)ty1, (float)tx2, (float)ty2, (float)x2, (float)y2);
        return p;
    }

    private static Path createBracket(Device device, double angle, double x, double y, double w, double h) {
        double rx = w / 2.0;
        double ry = h / 2.0;
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double x11 = cx + rx * Math.cos(angle - 1.5707963267948966) + 0.2 * rx * Math.cos(angle);
        double y11 = cy + ry * Math.sin(angle - 1.5707963267948966) + 0.2 * ry * Math.sin(angle);
        double tx11 = cx + 0.9 * rx * Math.cos(angle - 1.5707963267948966) + 0.2 * rx * Math.cos(angle - Math.PI);
        double ty11 = cy + 0.9 * ry * Math.sin(angle - 1.5707963267948966) + 0.2 * ry * Math.sin(angle - Math.PI);
        double tx21 = cx + 0.1 * rx * Math.cos(angle - 1.5707963267948966) + 0.2 * rx * Math.cos(angle);
        double ty21 = cy + 0.1 * ry * Math.sin(angle - 1.5707963267948966) + 0.2 * ry * Math.sin(angle);
        double x21 = cx + 0.2 * rx * Math.cos(angle - Math.PI);
        double y21 = cy + 0.2 * ry * Math.sin(angle - Math.PI);
        Path s1 = new Path(device);
        s1.moveTo((float)x11, (float)y11);
        s1.cubicTo((float)tx11, (float)ty11, (float)tx21, (float)ty21, (float)x21, (float)y21);
        double x12 = cx + rx * Math.cos(angle + 1.5707963267948966) + 0.2 * rx * Math.cos(angle);
        double y12 = cy + ry * Math.sin(angle + 1.5707963267948966) + 0.2 * ry * Math.sin(angle);
        double tx12 = cx + 0.9 * rx * Math.cos(angle + 1.5707963267948966) + 0.2 * rx * Math.cos(angle - Math.PI);
        double ty12 = cy + 0.9 * ry * Math.sin(angle + 1.5707963267948966) + 0.2 * ry * Math.sin(angle - Math.PI);
        double tx22 = cx + 0.1 * rx * Math.cos(angle + 1.5707963267948966) + 0.2 * rx * Math.cos(angle);
        double ty22 = cy + 0.1 * ry * Math.sin(angle + 1.5707963267948966) + 0.2 * ry * Math.sin(angle);
        double x22 = cx + 0.2 * rx * Math.cos(angle - Math.PI);
        double y22 = cy + 0.2 * ry * Math.sin(angle - Math.PI);
        Path s2 = new Path(device);
        s2.moveTo((float)x12, (float)y12);
        s2.cubicTo((float)tx12, (float)ty12, (float)tx22, (float)ty22, (float)x22, (float)y22);
        Path b = new Path(device);
        b.addPath(s1);
        b.addPath(s2);
        s1.dispose();
        s2.dispose();
        return b;
    }

    private Path createRepetition(Device device, double angle, double x, double y, double w, double h) {
        double r = Math.min(w, h);
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        Path p = new Path(device);
        double x1 = cx + r * Math.cos(angle - 1.5707963267948966) + r / 4.0 * Math.cos(angle + Math.PI);
        double y1 = cy + r * Math.sin(angle - 1.5707963267948966) + r / 4.0 * Math.sin(angle + Math.PI);
        p.moveTo((float)x1, (float)y1);
        double x2 = cx + r * Math.cos(angle - 1.5707963267948966);
        double y2 = cy + r * Math.sin(angle - 1.5707963267948966);
        p.lineTo((float)x2, (float)y2);
        double x3 = cx + r * Math.cos(angle + 1.5707963267948966);
        double y3 = cy + r * Math.sin(angle + 1.5707963267948966);
        p.lineTo((float)x3, (float)y3);
        double x4 = cx + r * Math.cos(angle + 1.5707963267948966) + r / 4.0 * Math.cos(angle + Math.PI);
        double y4 = cy + r * Math.sin(angle + 1.5707963267948966) + r / 4.0 * Math.sin(angle + Math.PI);
        p.lineTo((float)x4, (float)y4);
        p.lineTo((float)x3, (float)y3);
        p.lineTo((float)x2, (float)y2);
        p.close();
        return p;
    }

    private Path createShape(Device device, Residue node, Rectangle par_bbox, Rectangle cur_bbox, Rectangle sup_bbox, ResAngle orientation) {
        Point ps;
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        String shape = style.getShape();
        if (shape == null || shape.equals("none") || shape.equals("-")) {
            return null;
        }
        float x = cur_bbox.x;
        float y = cur_bbox.y;
        float w = cur_bbox.width;
        float h = cur_bbox.height;
        if (shape.equals("point")) {
            Path path = new Path(device);
            path.addRectangle(x + w / 2.0f, y + h / 2.0f, 0.0f, 0.0f);
            path.close();
            return path;
        }
        if (shape.equals("square")) {
            Path path = new Path(device);
            path.addRectangle(x, y, w, h);
            path.close();
            return path;
        }
        if (shape.equals("circle")) {
            Path path = new Path(device);
            path.addArc(x, y, w, h, 0.0f, 360.0f);
            path.close();
            return path;
        }
        if (shape.equals("diamond")) {
            return ResidueRendererSWT.createDiamond(device, x, y, w, h);
        }
        if (shape.equals("flatdiamond")) {
            return ResidueRendererSWT.createFlatDiamond(device, x, y, w, h);
        }
        if (shape.equals("rhombus")) {
            return ResidueRendererSWT.createRhombus(device, x, y, w, h);
        }
        if (shape.equals("star")) {
            return ResidueRendererSWT.createStar(device, x, y, w, h, 5);
        }
        if (shape.equals("sixstar")) {
            return ResidueRendererSWT.createStar(device, x, y, w, h, 6);
        }
        if (shape.equals("sevenstar")) {
            return ResidueRendererSWT.createStar(device, x, y, w, h, 7);
        }
        if (shape.equals("pentagon")) {
            return ResidueRendererSWT.createPentagon(device, x, y, w, h);
        }
        if (shape.equals("hexagon")) {
            return ResidueRendererSWT.createHexagon(device, x, y, w, h);
        }
        if (shape.equals("flathexagon")) {
            return ResidueRendererSWT.createFlatHexagon(device, x, y, w, h);
        }
        if (shape.equals("heptagon")) {
            return ResidueRendererSWT.createHeptagon(device, x, y, w, h);
        }
        if (shape.equals("flatsquare")) {
            Path path = new Path(device);
            path.addRectangle(x, y + h * 0.25f, w, h * 0.5f);
            path.close();
            return path;
        }
        Point pp = par_bbox != null ? Geometry.center(par_bbox) : Geometry.center(cur_bbox);
        Point pc = Geometry.center(cur_bbox);
        Point point = ps = sup_bbox != null ? Geometry.center(sup_bbox) : Geometry.center(cur_bbox);
        if (shape.equals("triangle")) {
            return ResidueRendererSWT.createTriangle(device, Geometry.angle(pp, ps), x, y, w, h);
        }
        if (shape.equals("hatdiamond")) {
            return ResidueRendererSWT.createHatDiamond(device, x, y, w, h);
        }
        if (shape.equals("rhatdiamond")) {
            return ResidueRendererSWT.createRHatDiamond(device, x, y, w, h);
        }
        if (shape.equals("bracket")) {
            return ResidueRendererSWT.createBracket(device, orientation.opposite().getAngle(), x, y, w, h);
        }
        if (shape.equals("startrep")) {
            return this.createRepetition(device, orientation.opposite().getAngle(), x, y, w, h);
        }
        if (shape.equals("endrep")) {
            return this.createRepetition(device, orientation.getAngle(), x, y, w, h);
        }
        if (shape.startsWith("acleavage")) {
            Vector tokens = TextUtils.tokenize((String)shape, (String)"_");
            int first_pos = Integer.parseInt((String)tokens.elementAt(1));
            int last_pos = Integer.parseInt((String)tokens.elementAt(2));
            return ResidueRendererSWT.createCrossRingCleavage(device, Geometry.angle(pc, ps), x, y, w, h, first_pos, last_pos);
        }
        if (shape.equals("bcleavage")) {
            return ResidueRendererSWT.createCleavage(device, Geometry.angle(ps, pc), x, y, w, h, false);
        }
        if (shape.equals("ccleavage")) {
            return ResidueRendererSWT.createCleavage(device, Geometry.angle(ps, pc), x, y, w, h, true);
        }
        if (shape.startsWith("xcleavage")) {
            Vector tokens = TextUtils.tokenize((String)shape, (String)"_");
            int first_pos = Integer.parseInt((String)tokens.elementAt(1));
            int last_pos = Integer.parseInt((String)tokens.elementAt(2));
            return ResidueRendererSWT.createCrossRingCleavage(device, Geometry.angle(pp, pc), x, y, w, h, first_pos, last_pos);
        }
        if (shape.equals("ycleavage")) {
            return ResidueRendererSWT.createCleavage(device, Geometry.angle(pp, pc), x, y, w, h, true);
        }
        if (shape.equals("zcleavage")) {
            return ResidueRendererSWT.createCleavage(device, Geometry.angle(pp, pc), x, y, w, h, false);
        }
        if (shape.equals("end")) {
            return ResidueRendererSWT.createEnd(device, Geometry.angle(pp, ps), x, y, w, h);
        }
        Path p = new Path(device);
        p.addRectangle((float)cur_bbox.x, (float)cur_bbox.y, (float)cur_bbox.width, (float)cur_bbox.height);
        return p;
    }

    private Path createRepetitionText(Device device, double angle, double x, double y, double w, double h, int min, int max) {
        Path pText;
        double dist;
        Rectangle tb;
        String text;
        double r = Math.min(w, h);
        double cx = x + w / 2.0;
        double cy = y + h / 2.0;
        double x2 = cx + r * Math.cos(angle - 1.5707963267948966);
        double y2 = cy + r * Math.sin(angle - 1.5707963267948966);
        double x3 = cx + r * Math.cos(angle + 1.5707963267948966);
        double y3 = cy + r * Math.sin(angle + 1.5707963267948966);
        Path ret = new Path(device);
        if (min >= 0 || max >= 0) {
            double ymin;
            double xmin;
            text = min >= 0 ? "" + min : "0";
            tb = TextShapeUtils.textBounds(device, text, this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, this.theGraphicOptions.LINKAGE_INFO_SIZE);
            dist = Geometry.isUp(angle) || Geometry.isDown(angle) ? tb.width / 2 + 4 : tb.height / 2 + 4;
            if (Geometry.isLeft(angle) || Geometry.isUp(angle)) {
                xmin = x2 + dist * Math.cos(angle - 1.5707963267948966) - (double)tb.width / 2.0;
                ymin = y2 + dist * Math.sin(angle - 1.5707963267948966) - (double)tb.height / 2.0;
            } else {
                xmin = x3 + dist * Math.cos(angle + 1.5707963267948966) - (double)tb.width / 2.0;
                ymin = y3 + dist * Math.sin(angle + 1.5707963267948966) - (double)tb.height / 2.0;
            }
            pText = TextShapeUtils.getTextPath(device, xmin, ymin, text, this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, this.theGraphicOptions.LINKAGE_INFO_SIZE);
            ret.addPath(pText);
            pText.dispose();
        }
        if (min >= 0 || max >= 0) {
            double ymax;
            double xmax;
            text = max >= 0 ? "" + max : "+inf";
            tb = TextShapeUtils.textBounds(device, text, this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, this.theGraphicOptions.LINKAGE_INFO_SIZE);
            dist = Geometry.isUp(angle) || Geometry.isDown(angle) ? tb.width / 2 + 4 : tb.height / 2 + 4;
            if (Geometry.isLeft(angle) || Geometry.isUp(angle)) {
                xmax = x3 + dist * Math.cos(angle + 1.5707963267948966) - (double)tb.width / 2.0;
                ymax = y3 + dist * Math.sin(angle + 1.5707963267948966) - (double)tb.height / 2.0;
            } else {
                xmax = x2 + dist * Math.cos(angle - 1.5707963267948966) - (double)tb.width / 2.0;
                ymax = y2 + dist * Math.sin(angle - 1.5707963267948966) - (double)tb.height / 2.0;
            }
            pText = TextShapeUtils.getTextPath(device, xmax, ymax, text, this.theGraphicOptions.LINKAGE_INFO_FONT_FACE, this.theGraphicOptions.LINKAGE_INFO_SIZE);
            ret.addPath(pText);
            pText.dispose();
        }
        return ret;
    }

    private Path createTextShape(Device device, Residue node, Rectangle par_bbox, Rectangle cur_bbox, Rectangle sup_bbox, ResAngle orientation) {
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        String shape = style.getShape();
        if (shape == null || shape.equals("none") || shape.equals("-")) {
            return null;
        }
        double x = cur_bbox.x;
        double y = cur_bbox.y;
        double w = cur_bbox.width;
        double h = cur_bbox.height;
        if (shape.equals("endrep")) {
            return this.createRepetitionText(device, orientation.getAngle(), x, y, w, h, node.getMinRepetitions(), node.getMaxRepetitions());
        }
        return null;
    }

    private static Path createRectangle(Device device, float x, float y, float w, float h) {
        Path p = new Path(device);
        p.addRectangle(x, y, w, h);
        p.close();
        return p;
    }

    private static Path createTriangle(Device device, float x1, float y1, float x2, float y2, float x3, float y3) {
        Path p = new Path(device);
        p.moveTo(x1, y1);
        p.lineTo(x2, y2);
        p.lineTo(x3, y3);
        p.close();
        return p;
    }

    private static Path createHalf(Device device, float rx, float ry, float cx, float cy) {
        double step = 1.2566370614359172;
        Path p = new Path(device);
        p.moveTo((float)((double)cx - 0.5 + (double)rx * Math.cos(5.0 * step - 1.5707963267948966)), (float)((double)cy + (double)ry * Math.sin(5.0 * step - 1.5707963267948966)));
        p.lineTo((float)((double)cx - 0.5 + (double)rx * Math.cos(4.0 * step - 1.5707963267948966)), (float)((double)cy + (double)ry * Math.sin(4.0 * step - 1.5707963267948966)));
        p.lineTo((float)((double)cx - 0.5 + (double)rx * Math.cos(3.0 * step - 1.5707963267948966)), (float)((double)cy + (double)ry * Math.sin(3.0 * step - 1.5707963267948966)));
        p.lineTo((float)((double)cx - 0.5 + (double)rx * Math.cos(2.5 * step - 1.5707963267948966)), (float)((double)cy + (double)ry * Math.sin(3.0 * step - 1.5707963267948966)));
        p.close();
        return p;
    }

    private static Path createCheckered(Device device, float x, float y, float w, float h) {
        Path c = new Path(device);
        Path p1 = new Path(device);
        p1.addRectangle(x + w / 2.0f, y, w / 2.0f, h / 2.0f);
        p1.close();
        c.addPath(p1);
        p1.dispose();
        Path p2 = new Path(device);
        p2.addRectangle(x, y + h / 2.0f, w / 2.0f, h / 2.0f);
        p2.close();
        c.addPath(p2);
        p2.dispose();
        return c;
    }

    private static Path createArc(Device device, double x, double y, double w, double h, int start_pos, int end_pos) {
        Path p = new Path(device);
        p.addArc((float)(x - 0.5 * w), (float)(y - 0.5 * h), (float)(2.0 * w), (float)(2.0 * h), (float)((double)(-end_pos) * 60.0 + 30.0), (float)((double)(-((start_pos - end_pos + 6) % 6)) * 60.0));
        p.lineTo((float)(x + 0.5 * w), (float)(y + 0.5 * h));
        p.close();
        return p;
    }

    private Path createFillShape(Device device, Residue node, Rectangle cur_bbox) {
        ResidueStyle style = this.theResidueStyleDictionary.getStyle(node);
        String fillstyle = style.getFillStyle();
        float x = cur_bbox.x;
        float y = cur_bbox.y;
        float w = cur_bbox.width;
        float h = cur_bbox.height;
        if (fillstyle.equals("empty")) {
            return null;
        }
        if (fillstyle.equals("full")) {
            return ResidueRendererSWT.createRectangle(device, cur_bbox.x, cur_bbox.y, cur_bbox.width, cur_bbox.height);
        }
        if (fillstyle.equals("half")) {
            return ResidueRendererSWT.createHalf(device, w / 2.0f, h / 2.0f, x + w / 2.0f, y + h / 2.0f);
        }
        if (fillstyle.equals("left")) {
            return ResidueRendererSWT.createRectangle(device, x, y, w / 2.0f, h);
        }
        if (fillstyle.equals("top")) {
            return ResidueRendererSWT.createRectangle(device, x, y, w, h / 2.0f);
        }
        if (fillstyle.equals("right")) {
            return ResidueRendererSWT.createRectangle(device, x + w / 2.0f, y, w / 2.0f, h);
        }
        if (fillstyle.equals("bottom")) {
            return ResidueRendererSWT.createRectangle(device, x, y + h / 2.0f, w, h / 2.0f);
        }
        if (fillstyle.equals("topleft")) {
            return ResidueRendererSWT.createTriangle(device, x, y, x + w, y, x, y + h);
        }
        if (fillstyle.equals("topright")) {
            return ResidueRendererSWT.createTriangle(device, x, y, x + w, y, x + w, y + h);
        }
        if (fillstyle.equals("bottomright")) {
            return ResidueRendererSWT.createTriangle(device, x + w, y, x + w, y + h, x, y + h);
        }
        if (fillstyle.equals("bottomleft")) {
            return ResidueRendererSWT.createTriangle(device, x, y, x + w, y + h, x, y + h);
        }
        float cx = x + w / 2.0f;
        float cy = y + h / 2.0f;
        float rx = w / 6.0f;
        float ry = h / 6.0f;
        if (fillstyle.equals("circle")) {
            Path p = new Path(device);
            p.addArc(cx - rx, cy - ry, 2.0f * rx, 2.0f * ry, 0.0f, 360.0f);
            p.close();
            return p;
        }
        if (fillstyle.equals("checkered")) {
            return ResidueRendererSWT.createCheckered(device, x, y, w, h);
        }
        if (fillstyle.startsWith("arc")) {
            Vector tokens = TextUtils.tokenize((String)fillstyle, (String)"_");
            int first_pos = Integer.parseInt((String)tokens.elementAt(1));
            int last_pos = Integer.parseInt((String)tokens.elementAt(2));
            return ResidueRendererSWT.createArc(device, x, y, w, h, first_pos, last_pos);
        }
        return null;
    }
}

