/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.spectrum.chart;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import org.grits.toolbox.display.control.spectrum.chart.GRITSMSSpectraRangeAxis;
import org.grits.toolbox.display.control.spectrum.chart.GRITSXYPlot;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class GRITSJFreeChart
extends JFreeChart {
    private static final long serialVersionUID = 1287819122582176394L;
    private static ChartTheme currentTheme = new StandardChartTheme("JFree");

    public GRITSJFreeChart(Plot plot) {
        super(plot);
    }

    public GRITSJFreeChart(String title, Font titleFont, Plot plot, boolean createLegend, HashMap<Double, List<Object>> htPeakLabels) {
        super(title, titleFont, plot, createLegend);
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        super.draw(g2, area);
    }

    public static GRITSJFreeChart createXYBarChart(String title, String xAxisLabel, boolean dateAxis, String yAxisLabel, IntervalXYDataset dataset, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls, HashMap<Double, List<Object>> htPeakLabels) {
        DateAxis domainAxis;
        ParamChecks.nullNotPermitted((Object)orientation, (String)"orientation");
        if (dateAxis) {
            domainAxis = new DateAxis(xAxisLabel);
        } else {
            NumberAxis axis = new NumberAxis(xAxisLabel);
            axis.setAutoRangeIncludesZero(false);
            domainAxis = axis;
        }
        GRITSMSSpectraRangeAxis valueAxis = new GRITSMSSpectraRangeAxis(yAxisLabel);
        XYBarRenderer renderer = new XYBarRenderer();
        if (tooltips) {
            StandardXYToolTipGenerator tt = dateAxis ? StandardXYToolTipGenerator.getTimeSeriesInstance() : new StandardXYToolTipGenerator();
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)tt);
        }
        if (urls) {
            renderer.setURLGenerator((XYURLGenerator)new StandardXYURLGenerator());
        }
        GRITSXYPlot plot = new GRITSXYPlot((XYDataset)dataset, (ValueAxis)domainAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer, htPeakLabels);
        plot.setOrientation(orientation);
        GRITSJFreeChart chart = new GRITSJFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend, htPeakLabels);
        currentTheme.apply((JFreeChart)chart);
        return chart;
    }

    public static GRITSJFreeChart createXYLineChart(String title, String xAxisLabel, String yAxisLabel, XYDataset dataset, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls, HashMap<Double, List<Object>> htPeakLabels) {
        ParamChecks.nullNotPermitted((Object)orientation, (String)"orientation");
        NumberAxis xAxis = new NumberAxis(xAxisLabel);
        xAxis.setAutoRangeIncludesZero(false);
        GRITSMSSpectraRangeAxis yAxis = new GRITSMSSpectraRangeAxis(yAxisLabel);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        GRITSXYPlot plot = new GRITSXYPlot(dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer, htPeakLabels);
        plot.setOrientation(orientation);
        if (tooltips) {
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        }
        if (urls) {
            renderer.setURLGenerator((XYURLGenerator)new StandardXYURLGenerator());
        }
        GRITSJFreeChart chart = new GRITSJFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend, htPeakLabels);
        currentTheme.apply((JFreeChart)chart);
        return chart;
    }
}

