/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.launcher.BaseBlock;
import org.eclipse.pde.internal.ui.preferences.AddToJavaSearchJob;
import org.eclipse.pde.internal.ui.preferences.BuildJob;
import org.eclipse.pde.internal.ui.shared.target.TargetStatus;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.osgi.service.prefs.BackingStoreException;

public class MainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.pde.ui.MainPreferencePage";
    private Button fUseID;
    private Button fUseName;
    private Button fAutoManage;
    private Button fOverwriteBuildFiles;
    private Button fShowSourceBundles;
    private Button fPromptOnRemove;
    private Button fAddToJavaSearch;
    private Button fShowTargetStatus;
    private Button fAlwaysPreferWorkspace;
    private Button fDisableAPIAnalysisBuilder;
    private Text fRuntimeWorkspaceLocation;
    private Button fRuntimeWorkspaceLocationRadio;
    private Button fRuntimeWorkspacesContainerRadio;
    private Text fJUnitWorkspaceLocation;
    private Button fJUnitWorkspaceLocationRadio;
    private Button fJUnitWorkspacesContainerRadio;
    private Text fTestPluginPatternText;

    public MainPreferencePage() {
        this.setPreferenceStore(PDEPlugin.getDefault().getPreferenceStore());
        this.setDescription(PDEUIMessages.Preferences_MainPage_Description);
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        PDEPreferencesManager launchingStore = PDELaunchingPlugin.getDefault().getPreferenceManager();
        Composite composite = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        ((GridLayout)composite.getLayout()).verticalSpacing = 15;
        ((GridLayout)composite.getLayout()).marginTop = 15;
        Composite optionComp = SWTFactory.createComposite(composite, 1, 1, 768, 0, 0);
        this.fOverwriteBuildFiles = new Button(optionComp, 32);
        this.fOverwriteBuildFiles.setText(PDEUIMessages.MainPreferencePage_promptBeforeOverwrite);
        this.fOverwriteBuildFiles.setSelection(!"always".equals(store.getString("Preferences.MainPage.overwriteBuildFilesOnExport")));
        this.fAutoManage = new Button(optionComp, 32);
        this.fAutoManage.setText(PDEUIMessages.MainPreferencePage_updateStale);
        this.fAutoManage.setSelection(launchingStore.getBoolean("Preferences.MainPage.automanageDependencies"));
        this.fPromptOnRemove = new Button(optionComp, 32);
        this.fPromptOnRemove.setText(PDEUIMessages.MainPreferencePage_promtBeforeRemove);
        this.fPromptOnRemove.setSelection(!"always".equals(store.getString("Preferences.MainPage.promptRemoveTarget")));
        this.fPromptOnRemove.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> PDEPlugin.getDefault().getPreferenceStore().setValue("Preferences.MainPage.promptRemoveTarget", this.fPromptOnRemove.getSelection() ? "prompt" : "always")));
        this.fAddToJavaSearch = new Button(optionComp, 32);
        this.fAddToJavaSearch.setText(PDEUIMessages.MainPreferencePage_addToJavaSearch);
        this.fAddToJavaSearch.setSelection(store.getBoolean("Preferences.MainPage.addToJavaSearch"));
        this.fShowTargetStatus = new Button(optionComp, 32);
        this.fShowTargetStatus.setText(PDEUIMessages.MainPreferencePage_ShowTargetStatus);
        this.fShowTargetStatus.setSelection(store.getBoolean("Preferences.MainPage.showTargetStatus"));
        this.fAlwaysPreferWorkspace = new Button(optionComp, 32);
        this.fAlwaysPreferWorkspace.setText(PDEUIMessages.MainPreferencePage_WorkspacePluginsOverrideTarget);
        this.fAlwaysPreferWorkspace.setSelection(store.getBoolean("Preferences.MainPage.workspacePluginsOverrideTarget"));
        this.fAlwaysPreferWorkspace.setToolTipText(PDEUIMessages.MainPreferencePage_WorkspacePluginsOverrideTargetTooltip);
        this.fDisableAPIAnalysisBuilder = new Button(optionComp, 32);
        this.fDisableAPIAnalysisBuilder.setText(PDEUIMessages.MainPreferencePage_DisableAPIAnalysisBuilder);
        this.fDisableAPIAnalysisBuilder.setSelection(store.getBoolean("Preferences.MainPage.disableAPIAnalysisBuilder"));
        Composite pathComposite = new Composite(optionComp, 0);
        pathComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        GridLayout layout = new GridLayout(2, false);
        layout.marginRight = 12;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pathComposite.setLayout((Layout)layout);
        pathComposite.setFont(optionComp.getFont());
        Group testGroup = SWTFactory.createGroup(composite, PDEUIMessages.MainPreferencePage_test_plugin_pattern_group, 2, 1, 768);
        Label testPluginPatternDescription = new Label((Composite)testGroup, 16384);
        testPluginPatternDescription.setText(PDEUIMessages.MainPreferencePage_test_plugin_pattern_description);
        testPluginPatternDescription.setFont(JFaceResources.getDialogFont());
        GridData gd2 = new GridData(768);
        gd2.widthHint = 200;
        gd2.horizontalSpan = 2;
        testPluginPatternDescription.setLayoutData((Object)gd2);
        Label testPluginPatternLabel = new Label((Composite)testGroup, 16384);
        testPluginPatternLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        testPluginPatternLabel.setText(PDEUIMessages.MainPreferencePage_test_plugin_pattern_label);
        testPluginPatternLabel.setFont(JFaceResources.getDialogFont());
        this.fTestPluginPatternText = new Text((Composite)testGroup, 2052);
        this.fTestPluginPatternText.addModifyListener(e -> this.updateOKStatus());
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        this.fTestPluginPatternText.setLayoutData((Object)gd);
        this.fTestPluginPatternText.setText(store.getString("Preferences.MainPage.testPluginPattern"));
        TextContentAdapter contentAdapter = new TextContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(true);
        ContentAssistCommandAdapter contentAssist = new ContentAssistCommandAdapter((Control)this.fTestPluginPatternText, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        contentAssist.setEnabled(true);
        Label testPluginPatternNote = new Label((Composite)testGroup, 16384);
        testPluginPatternNote.setText(PDEUIMessages.MainPreferencePage_test_plugin_pattern_note);
        testPluginPatternNote.setFont(JFaceResources.getDialogFont());
        testPluginPatternNote.setLayoutData((Object)gd2);
        Group group = SWTFactory.createGroup(composite, PDEUIMessages.Preferences_MainPage_showObjects, 2, 1, 768);
        this.fUseID = new Button((Composite)group, 16);
        this.fUseID.setText(PDEUIMessages.Preferences_MainPage_useIds);
        this.fUseName = new Button((Composite)group, 16);
        this.fUseName.setText(PDEUIMessages.Preferences_MainPage_useFullNames);
        this.fShowSourceBundles = SWTFactory.createCheckButton((Composite)group, PDEUIMessages.MainPreferencePage_showSourceBundles, null, store.getBoolean("Preferences.MainPage.showSourceBundles"), 2);
        if (store.getString("Preferences.MainPage.showObjects").equals("useIds")) {
            this.fUseID.setSelection(true);
        } else {
            this.fUseName.setSelection(true);
        }
        new DefaultRuntimeWorkspaceBlock().createControl(composite);
        this.fRuntimeWorkspaceLocation.setText(launchingStore.getString("Preferences.MainPage.runtimeWorkspaceLocation"));
        boolean runtimeLocationIsContainer = launchingStore.getBoolean("Preferences.MainPage.runtimeWorkspaceLocationIsContainer");
        this.fRuntimeWorkspaceLocationRadio.setSelection(!runtimeLocationIsContainer);
        this.fRuntimeWorkspacesContainerRadio.setSelection(runtimeLocationIsContainer);
        new DefaultJUnitWorkspaceBlock().createControl(composite);
        this.fJUnitWorkspaceLocation.setText(launchingStore.getString("Preferences.MainPage.junitWorkspaceLocation"));
        boolean jUnitLocationIsContainer = launchingStore.getBoolean("Preferences.MainPage.junitWorkspaceLocationIsContainer");
        this.fJUnitWorkspaceLocationRadio.setSelection(!jUnitLocationIsContainer);
        this.fJUnitWorkspacesContainerRadio.setSelection(jUnitLocationIsContainer);
        return composite;
    }

    /*
     * Unable to fully structure code
     */
    private boolean validateRegex() {
        block3: {
            try {
                Pattern.compile(this.fTestPluginPatternText.getText());
                break block3;
            }
            catch (PatternSyntaxException e) {
                locMessage = e.getLocalizedMessage();
                i = 0;
                ** while (i < locMessage.length() && "\n\r".indexOf((int)locMessage.charAt((int)i)) == -1)
            }
lbl-1000:
            // 1 sources

            {
                ++i;
                continue;
            }
lbl11:
            // 1 sources

            this.setErrorMessage(locMessage.substring(0, i));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    final void updateOKStatus() {
        boolean regexStatus = this.validateRegex();
        this.setValid(regexStatus);
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        Dialog.applyDialogFont((Control)this.getControl());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.main_preference_page");
    }

    public boolean performOk() {
        String pluginPatternText;
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        if (this.fUseID.getSelection()) {
            store.setValue("Preferences.MainPage.showObjects", "useIds");
        } else {
            store.setValue("Preferences.MainPage.showObjects", "useNames");
        }
        store.setValue("Preferences.MainPage.overwriteBuildFilesOnExport", this.fOverwriteBuildFiles.getSelection() ? "prompt" : "always");
        store.setValue("Preferences.MainPage.showSourceBundles", this.fShowSourceBundles.getSelection());
        boolean synchJavaSearch = this.fAddToJavaSearch.getSelection();
        if (store.getBoolean("Preferences.MainPage.addToJavaSearch") != synchJavaSearch) {
            store.setValue("Preferences.MainPage.addToJavaSearch", synchJavaSearch);
            try {
                if (synchJavaSearch) {
                    ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
                    if (service != null) {
                        AddToJavaSearchJob.synchWithTarget(service.getWorkspaceTargetDefinition());
                    }
                } else {
                    AddToJavaSearchJob.clearAll();
                }
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
        }
        boolean useWorkspace = this.fAlwaysPreferWorkspace.getSelection();
        if (store.getBoolean("Preferences.MainPage.workspacePluginsOverrideTarget") != useWorkspace) {
            store.setValue("Preferences.MainPage.workspacePluginsOverrideTarget", this.fAlwaysPreferWorkspace.getSelection());
            PDEPreferencesManager prefs = PDECore.getDefault().getPreferencesManager();
            prefs.setValue("workspace_plugins_override_target", this.fAlwaysPreferWorkspace.getSelection());
            try {
                InstanceScope.INSTANCE.getNode("org.eclipse.pde.core").flush();
            }
            catch (BackingStoreException backingStoreException) {}
            PDECore.getDefault().getModelManager().targetReloaded(null);
        }
        if (!(pluginPatternText = this.fTestPluginPatternText.getText()).equals(store.getString("Preferences.MainPage.testPluginPattern"))) {
            store.setValue("Preferences.MainPage.testPluginPattern", pluginPatternText);
            PDEPreferencesManager prefs = PDECore.getDefault().getPreferencesManager();
            prefs.setValue("test_plugin_pattern", pluginPatternText);
        }
        boolean showTarget = this.fShowTargetStatus.getSelection();
        if (store.getBoolean("Preferences.MainPage.showTargetStatus") != showTarget) {
            store.setValue("Preferences.MainPage.showTargetStatus", showTarget);
            TargetStatus.refreshTargetStatus();
        }
        boolean disableAPIAnalysisBuilder = this.fDisableAPIAnalysisBuilder.getSelection();
        if (store.getBoolean("Preferences.MainPage.disableAPIAnalysisBuilder") != disableAPIAnalysisBuilder) {
            store.setValue("Preferences.MainPage.disableAPIAnalysisBuilder", this.fDisableAPIAnalysisBuilder.getSelection());
            PDEPreferencesManager prefs = PDECore.getDefault().getPreferencesManager();
            prefs.setValue("Preferences.MainPage.disableAPIAnalysisBuilder", this.fDisableAPIAnalysisBuilder.getSelection());
            IProject[] projects = BuildJob.getApiProjects();
            if (projects != null) {
                String message = PDEUIMessages.MainPreferencePage_askFullRebuild;
                int userInput = MessageDialog.open((int)3, (Shell)this.getShell(), (String)PDEUIMessages.MainPreferencePage_settingChanged, (String)message, (int)0, (String[])new String[]{PDEUIMessages.MainPreferencePage_build, PDEUIMessages.MainPreferencePage_notNow});
                if (userInput == 0) {
                    BuildJob.getBuildJob(projects).schedule();
                }
            }
        }
        PDEPlugin.getDefault().getPreferenceManager().savePluginPreferences();
        PDEPreferencesManager launchingStore = PDELaunchingPlugin.getDefault().getPreferenceManager();
        launchingStore.setValueOrRemove("Preferences.MainPage.automanageDependencies", this.fAutoManage.getSelection());
        launchingStore.setValueOrRemove("Preferences.MainPage.runtimeWorkspaceLocation", this.fRuntimeWorkspaceLocation.getText());
        launchingStore.setValueOrRemove("Preferences.MainPage.runtimeWorkspaceLocationIsContainer", this.fRuntimeWorkspacesContainerRadio.getSelection());
        launchingStore.setValueOrRemove("Preferences.MainPage.junitWorkspaceLocation", this.fJUnitWorkspaceLocation.getText());
        launchingStore.setValueOrRemove("Preferences.MainPage.junitWorkspaceLocationIsContainer", this.fJUnitWorkspacesContainerRadio.getSelection());
        try {
            launchingStore.flush();
        }
        catch (BackingStoreException e) {
            PDEPlugin.log(e);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        if (store.getDefaultString("Preferences.MainPage.showObjects").equals("useIds")) {
            this.fUseID.setSelection(true);
            this.fUseName.setSelection(false);
        } else {
            this.fUseID.setSelection(false);
            this.fUseName.setSelection(true);
        }
        this.fAutoManage.setSelection(false);
        this.fOverwriteBuildFiles.setSelection(true);
        this.fShowSourceBundles.setSelection(false);
        this.fPromptOnRemove.setSelection(true);
        this.fAddToJavaSearch.setSelection(store.getDefaultBoolean("Preferences.MainPage.addToJavaSearch"));
        this.fShowTargetStatus.setSelection(store.getDefaultBoolean("Preferences.MainPage.showTargetStatus"));
        this.fAlwaysPreferWorkspace.setSelection(store.getDefaultBoolean("Preferences.MainPage.workspacePluginsOverrideTarget"));
        this.fTestPluginPatternText.setText(store.getDefaultString("Preferences.MainPage.testPluginPattern"));
        PDEPreferencesManager launchingStore = PDELaunchingPlugin.getDefault().getPreferenceManager();
        boolean runtimeLocationIsContainer = launchingStore.getDefaultBoolean("Preferences.MainPage.runtimeWorkspaceLocationIsContainer");
        this.fRuntimeWorkspaceLocationRadio.setSelection(!runtimeLocationIsContainer);
        this.fRuntimeWorkspacesContainerRadio.setSelection(runtimeLocationIsContainer);
        this.fRuntimeWorkspaceLocation.setText(launchingStore.getDefaultString("Preferences.MainPage.runtimeWorkspaceLocation"));
        boolean jUnitLocationIsContainer = launchingStore.getDefaultBoolean("Preferences.MainPage.junitWorkspaceLocationIsContainer");
        this.fJUnitWorkspaceLocationRadio.setSelection(!jUnitLocationIsContainer);
        this.fJUnitWorkspacesContainerRadio.setSelection(jUnitLocationIsContainer);
        this.fJUnitWorkspaceLocation.setText(launchingStore.getDefaultString("Preferences.MainPage.junitWorkspaceLocation"));
    }

    public void setVisible(boolean visible) {
        this.fPromptOnRemove.setSelection(!"always".equals(PDEPlugin.getDefault().getPreferenceManager().getString("Preferences.MainPage.promptRemoveTarget")));
        super.setVisible(visible);
    }

    public void init(IWorkbench workbench) {
    }

    private final class DefaultJUnitWorkspaceBlock
    extends BaseBlock {
        DefaultJUnitWorkspaceBlock() {
            super(null);
        }

        public void createControl(Composite parent) {
            Group group = SWTFactory.createGroup(parent, PDEUIMessages.MainPreferencePage_junitWorkspaceGroup, 2, 1, 768);
            Composite radios = SWTFactory.createComposite((Composite)group, 2, 2, 768, 0, 0);
            MainPreferencePage.this.fJUnitWorkspaceLocationRadio = new Button(radios, 16);
            MainPreferencePage.this.fJUnitWorkspaceLocationRadio.setText(PDEUIMessages.MainPreferencePage_junitWorkspace_asLocation);
            MainPreferencePage.this.fJUnitWorkspaceLocationRadio.setLayoutData((Object)new GridData(32));
            MainPreferencePage.this.fJUnitWorkspaceLocationRadio.setSelection(true);
            MainPreferencePage.this.fJUnitWorkspacesContainerRadio = new Button(radios, 16);
            MainPreferencePage.this.fJUnitWorkspacesContainerRadio.setText(PDEUIMessages.MainPreferencePage_junitWorkspace_asContainer);
            MainPreferencePage.this.fJUnitWorkspacesContainerRadio.setLayoutData((Object)new GridData(32));
            this.createText((Composite)group, PDEUIMessages.WorkspaceDataBlock_location, 0);
            ((GridData)this.fLocationText.getLayoutData()).widthHint = 200;
            MainPreferencePage.this.fJUnitWorkspaceLocation = this.fLocationText;
            Composite buttons = SWTFactory.createComposite((Composite)group, 3, 2, 640, 0, 0);
            this.createButtons(buttons, new String[]{PDEUIMessages.MainPreferencePage_junitWorkspace_workspace, PDEUIMessages.MainPreferencePage_junitWorkspace_fileSystem, PDEUIMessages.MainPreferencePage_junitWorkspace_variables});
        }

        @Override
        protected String getName() {
            return PDEUIMessages.DefaultJUnitWorkspaceBlock_name;
        }

        @Override
        protected boolean isFile() {
            return false;
        }
    }

    private final class DefaultRuntimeWorkspaceBlock
    extends BaseBlock {
        DefaultRuntimeWorkspaceBlock() {
            super(null);
        }

        public void createControl(Composite parent) {
            Group group = SWTFactory.createGroup(parent, PDEUIMessages.MainPreferencePage_runtimeWorkspaceGroup, 2, 1, 768);
            Composite radios = SWTFactory.createComposite((Composite)group, 2, 2, 768, 0, 0);
            MainPreferencePage.this.fRuntimeWorkspaceLocationRadio = new Button(radios, 16);
            MainPreferencePage.this.fRuntimeWorkspaceLocationRadio.setText(PDEUIMessages.MainPreferencePage_runtimeWorkspace_asLocation);
            MainPreferencePage.this.fRuntimeWorkspaceLocationRadio.setLayoutData((Object)new GridData(32));
            MainPreferencePage.this.fRuntimeWorkspaceLocationRadio.setSelection(true);
            MainPreferencePage.this.fRuntimeWorkspacesContainerRadio = new Button(radios, 16);
            MainPreferencePage.this.fRuntimeWorkspacesContainerRadio.setText(PDEUIMessages.MainPreferencePage_runtimeWorkspace_asContainer);
            MainPreferencePage.this.fRuntimeWorkspacesContainerRadio.setLayoutData((Object)new GridData(32));
            this.createText((Composite)group, PDEUIMessages.WorkspaceDataBlock_location, 0);
            ((GridData)this.fLocationText.getLayoutData()).widthHint = 200;
            MainPreferencePage.this.fRuntimeWorkspaceLocation = this.fLocationText;
            Composite buttons = SWTFactory.createComposite((Composite)group, 3, 2, 640, 0, 0);
            this.createButtons(buttons, new String[]{PDEUIMessages.MainPreferencePage_runtimeWorkspace_workspace, PDEUIMessages.MainPreferencePage_runtimeWorkspace_fileSystem, PDEUIMessages.MainPreferencePage_runtimeWorkspace_variables});
        }

        @Override
        protected String getName() {
            return PDEUIMessages.WorkspaceDataBlock_name;
        }

        @Override
        protected boolean isFile() {
            return false;
        }
    }
}

